/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigesterImpl
implements Digester {
    private static final boolean _BASE_64 = PropsValues.PASSWORDS_DIGEST_ENCODING.equals("base64");
    private static final Log _log = LogFactoryUtil.getLog(DigesterImpl.class);

    public String digest(ByteBuffer byteBuffer) {
        return this.digest("SHA", byteBuffer);
    }

    public String digest(InputStream inputStream) {
        return this.digest("SHA", inputStream);
    }

    public String digest(String text) {
        return this.digest("SHA", text);
    }

    public String digest(String algorithm, ByteBuffer byteBuffer) {
        if (_BASE_64) {
            return this.digestBase64(algorithm, byteBuffer);
        }
        return this.digestHex(algorithm, byteBuffer);
    }

    public String digest(String algorithm, InputStream inputStream) {
        if (_BASE_64) {
            return this.digestBase64(algorithm, inputStream);
        }
        return this.digestHex(algorithm, inputStream);
    }

    public String digest(String algorithm, String ... text) {
        if (_BASE_64) {
            return this.digestBase64(algorithm, text);
        }
        return this.digestHex(algorithm, text);
    }

    public String digestBase64(ByteBuffer byteBuffer) {
        return this.digestBase64("SHA", byteBuffer);
    }

    public String digestBase64(InputStream inputStream) {
        return this.digestBase64("SHA", inputStream);
    }

    public String digestBase64(String text) {
        return this.digestBase64("SHA", text);
    }

    public String digestBase64(String algorithm, ByteBuffer byteBuffer) {
        byte[] bytes = this.digestRaw(algorithm, byteBuffer);
        return Base64.encode((byte[])bytes);
    }

    public String digestBase64(String algorithm, InputStream inputStream) {
        byte[] bytes = this.digestRaw(algorithm, inputStream);
        return Base64.encode((byte[])bytes);
    }

    public String digestBase64(String algorithm, String ... text) {
        byte[] bytes = this.digestRaw(algorithm, text);
        return Base64.encode((byte[])bytes);
    }

    public String digestHex(ByteBuffer byteBuffer) {
        return this.digestHex("SHA", byteBuffer);
    }

    public String digestHex(InputStream inputStream) {
        return this.digestHex("SHA", inputStream);
    }

    public String digestHex(String text) {
        return this.digestHex("SHA", text);
    }

    public String digestHex(String algorithm, ByteBuffer byteBuffer) {
        byte[] bytes = this.digestRaw(algorithm, byteBuffer);
        return StringUtil.bytesToHexString((byte[])bytes);
    }

    public String digestHex(String algorithm, InputStream inputStream) {
        byte[] bytes = this.digestRaw(algorithm, inputStream);
        return StringUtil.bytesToHexString((byte[])bytes);
    }

    public String digestHex(String algorithm, String ... text) {
        byte[] bytes = this.digestRaw(algorithm, text);
        return StringUtil.bytesToHexString((byte[])bytes);
    }

    public byte[] digestRaw(ByteBuffer byteBuffer) {
        return this.digestRaw("SHA", byteBuffer);
    }

    public byte[] digestRaw(String text) {
        return this.digestRaw("SHA", text);
    }

    public byte[] digestRaw(String algorithm, ByteBuffer byteBuffer) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(byteBuffer);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error((Throwable)noSuchAlgorithmException);
        }
        return messageDigest.digest();
    }

    public byte[] digestRaw(String algorithm, InputStream inputStream1) {
        MessageDigest messageDigest = null;
        try (InputStream inputStream2 = inputStream1;){
            messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[StreamUtil.BUFFER_SIZE];
            int read = 0;
            while ((read = inputStream2.read(buffer)) != -1) {
                if (read <= 0) continue;
                messageDigest.update(buffer, 0, read);
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error((Throwable)noSuchAlgorithmException);
        }
        return messageDigest.digest();
    }

    public byte[] digestRaw(String algorithm, String ... text) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
            StringBundler sb = new StringBundler(text.length * 2 - 1);
            for (String t : text) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append(t);
            }
            String s = sb.toString();
            messageDigest.update(s.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error((Throwable)noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _log.error((Throwable)unsupportedEncodingException);
        }
        return messageDigest.digest();
    }
}

