/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.permission.ExpandoColumnPermissionUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.service.base.ExpandoValueServiceBaseImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class ExpandoValueServiceImpl
extends ExpandoValueServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ExpandoColumnLocalService.class)
    private ExpandoColumnLocalService _expandoColumnLocalService;

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException {
        ExpandoColumnPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)this._expandoColumnLocalService.getColumn(companyId, this._classNameLocalService.getClassNameId(className), tableName, columnName), (String)"UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(companyId, this._classNameLocalService.getClassNameId(className), tableName, columnName);
        ExpandoColumnPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)expandoColumn, (String)"UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public void addValues(long companyId, String className, String tableName, long classPK, Map<String, Serializable> attributeValues) throws PortalException {
        for (Map.Entry<String, Serializable> entry : attributeValues.entrySet()) {
            this.addValue(companyId, className, tableName, entry.getKey(), classPK, entry.getValue());
        }
    }

    public Map<String, Serializable> getData(long companyId, String className, String tableName, Collection<String> columnNames, long classPK) throws PortalException {
        Map attributeValues = this.expandoValueLocalService.getData(companyId, className, tableName, columnNames, classPK);
        for (String columnName : columnNames) {
            ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(companyId, this._classNameLocalService.getClassNameId(className), tableName, columnName);
            if (ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)expandoColumn, (String)"VIEW")) continue;
            attributeValues.remove(columnName);
        }
        return attributeValues;
    }

    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoColumn column = this._expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (column != null && ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"VIEW")) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
        }
        return null;
    }

    public JSONObject getJSONData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoColumn column = this._expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (column == null || !ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"VIEW")) {
            return null;
        }
        String data = String.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK));
        if (Validator.isNull((String)data)) {
            return null;
        }
        if (data.startsWith("{")) {
            return JSONFactoryUtil.createJSONObject((String)data);
        }
        return JSONUtil.put((String)"data", (Object)data);
    }
}

