/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.internal.LiferayPortletURLPrivilegedAction;
import com.liferay.portlet.internal.RenderData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class RenderStateUtil {
    public static String generateJSON(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) {
        return RenderStateUtil.generateJSON(httpServletRequest, themeDisplay, Collections.emptyMap());
    }

    public static String generateJSON(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Map<String, RenderData> renderDataMap) {
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (layoutTypePortlet != null) {
            return String.valueOf(RenderStateUtil._getPageStateJSONObject(httpServletRequest, themeDisplay, layoutTypePortlet, renderDataMap));
        }
        return "";
    }

    private static String _createActionURL(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        LiferayPortletURL liferayPortletURL = RenderStateUtil._createLiferayPortletURL(httpServletRequest, layout, portlet, "ACTION_PHASE", MimeResponse.Copy.NONE);
        return liferayPortletURL.toString();
    }

    private static LiferayPortletURL _createLiferayPortletURL(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet, String lifecycle, MimeResponse.Copy copy) {
        LiferayPortletURLPrivilegedAction liferayPortletURLPrivilegedAction = new LiferayPortletURLPrivilegedAction(portlet.getPortletId(), lifecycle, copy, layout, portlet, httpServletRequest);
        return liferayPortletURLPrivilegedAction.run();
    }

    private static String _createRenderURL(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        LiferayPortletURL liferayPortletURL = RenderStateUtil._createLiferayPortletURL(httpServletRequest, layout, portlet, "RENDER_PHASE", MimeResponse.Copy.NONE);
        return liferayPortletURL.toString();
    }

    private static String _createResourceURL(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        LiferayPortletURL liferayPortletURL = RenderStateUtil._createLiferayPortletURL(httpServletRequest, layout, portlet, "RESOURCE_PHASE", MimeResponse.Copy.NONE);
        liferayPortletURL.setCacheability("cacheLevelFull");
        return StringUtil.removeSubstring((String)liferayPortletURL.toString(), (String)"&p_p_cacheability=cacheLevelFull");
    }

    private static JSONArray _getAllowedPortletModesJSONArray(Portlet portlet) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Set allPortletModes = portlet.getAllPortletModes();
        for (String portletMode : allPortletModes) {
            jsonArray.put(portletMode);
        }
        return jsonArray;
    }

    private static JSONArray _getAllowedWindowStatesJSONArray(Portlet portlet) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Set allWindowStates = portlet.getAllWindowStates();
        for (String windowState : allWindowStates) {
            jsonArray.put(windowState);
        }
        return jsonArray;
    }

    private static Map<String, String[]> _getChangedPublicRenderParameters(HttpServletRequest httpServletRequest, long plid, List<Portlet> portlets) {
        HashMap<String, String[]> changedPublicRenderParameters = new HashMap<String, String[]>();
        Map<String, String[]> currentPublicRenderParameters = PublicRenderParametersPool.get(httpServletRequest, plid);
        for (Portlet portlet : portlets) {
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.getSpecMajorVersion() >= 3) {
                for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                    String[] currentValue = currentPublicRenderParameters.get(PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName()));
                    if (currentValue == null) continue;
                    changedPublicRenderParameters.put(publicRenderParameter.getIdentifier(), currentValue);
                }
                continue;
            }
            Map<String, String[]> privateRenderParameterMap = RenderParametersPool.get(httpServletRequest, plid, portlet.getPortletId());
            if (privateRenderParameterMap == null) continue;
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                String[] values = privateRenderParameterMap.get(publicRenderParameter.getIdentifier());
                if (values == null) continue;
                changedPublicRenderParameters.put(publicRenderParameter.getIdentifier(), values);
            }
        }
        return changedPublicRenderParameters;
    }

    private static JSONObject _getPageStateJSONObject(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, LayoutTypePortlet layoutTypePortlet, Map<String, RenderData> renderDataMap) {
        List portlets = layoutTypePortlet.getAllPortlets();
        return JSONUtil.put((String)"encodedCurrentURL", (Object)URLCodec.encodeURL((String)PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest))).put("portlets", RenderStateUtil._getPortletsJSONObject(httpServletRequest, themeDisplay, layoutTypePortlet, portlets, renderDataMap)).put("prpMap", RenderStateUtil._getPRPGroupsJSONObject(portlets));
    }

    private static JSONObject _getPortletJSONObject(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, LayoutTypePortlet layoutTypePortlet, Portlet portlet, RenderData renderData, Map<String, String[]> changedPublicRenderParameters) {
        return JSONUtil.put((String)"allowedPM", (Object)RenderStateUtil._getAllowedPortletModesJSONArray(portlet)).put("allowedWS", RenderStateUtil._getAllowedWindowStatesJSONArray(portlet)).put("encodedActionURL", URLCodec.encodeURL((String)RenderStateUtil._createActionURL(httpServletRequest, themeDisplay.getLayout(), portlet))).put("encodedRenderURL", URLCodec.encodeURL((String)RenderStateUtil._createRenderURL(httpServletRequest, themeDisplay.getLayout(), portlet))).put("encodedResourceURL", URLCodec.encodeURL((String)RenderStateUtil._createResourceURL(httpServletRequest, themeDisplay.getLayout(), portlet))).put("pubParms", RenderStateUtil._getPortletPRPJSONObject(portlet)).put("renderData", RenderStateUtil._getRenderDataJSONObject(renderData)).put("state", RenderStateUtil._getPortletStateJSONObject(httpServletRequest, themeDisplay, layoutTypePortlet, portlet, changedPublicRenderParameters));
    }

    private static PortletMode _getPortletMode(LayoutTypePortlet layoutTypePortlet, String portletId) {
        if (layoutTypePortlet.hasModeAboutPortletId(portletId)) {
            return LiferayPortletMode.ABOUT;
        }
        if (layoutTypePortlet.hasModeConfigPortletId(portletId)) {
            return LiferayPortletMode.CONFIG;
        }
        if (layoutTypePortlet.hasModeEditDefaultsPortletId(portletId)) {
            return LiferayPortletMode.EDIT_DEFAULTS;
        }
        if (layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            return LiferayPortletMode.EDIT_GUEST;
        }
        if (layoutTypePortlet.hasModeEditPortletId(portletId)) {
            return LiferayPortletMode.EDIT;
        }
        if (layoutTypePortlet.hasModeHelpPortletId(portletId)) {
            return LiferayPortletMode.HELP;
        }
        if (layoutTypePortlet.hasModePreviewPortletId(portletId)) {
            return LiferayPortletMode.PREVIEW;
        }
        if (layoutTypePortlet.hasModePrintPortletId(portletId)) {
            return LiferayPortletMode.PRINT;
        }
        String customPortletMode = layoutTypePortlet.getAddedCustomPortletMode();
        if (customPortletMode != null) {
            return new PortletMode(customPortletMode);
        }
        return LiferayPortletMode.VIEW;
    }

    private static JSONObject _getPortletParametersJSONObject(HttpServletRequest httpServletRequest, long plid, Portlet portlet, Map<String, String[]> changedPublicRenderParameters) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map<String, String[]> privateRenderParameters = RenderParametersPool.get(httpServletRequest, plid, portlet.getPortletId());
        if (privateRenderParameters != null) {
            for (Map.Entry<String, String[]> entry : privateRenderParameters.entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        Set publicRenderParameters = portlet.getPublicRenderParameters();
        for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
            String[] values = changedPublicRenderParameters.get(publicRenderParameter.getIdentifier());
            if (values == null) continue;
            jsonObject.put(publicRenderParameter.getIdentifier(), (Object)values);
        }
        return jsonObject;
    }

    private static JSONObject _getPortletPRPJSONObject(Portlet portlet) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Set publicRenderParameters = portlet.getPublicRenderParameters();
        for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
            jsonObject.put(publicRenderParameter.getIdentifier(), PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName()));
        }
        return jsonObject;
    }

    private static JSONObject _getPortletsJSONObject(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, LayoutTypePortlet layoutTypePortlet, List<Portlet> portlets, Map<String, RenderData> renderDataMap) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map<String, String[]> changedPublicRenderParameters = RenderStateUtil._getChangedPublicRenderParameters(httpServletRequest, themeDisplay.getPlid(), portlets);
        for (Portlet portlet : portlets) {
            jsonObject.put(PortalUtil.getPortletNamespace((String)portlet.getPortletId()), RenderStateUtil._getPortletJSONObject(httpServletRequest, themeDisplay, layoutTypePortlet, portlet, renderDataMap.get(portlet.getPortletId()), changedPublicRenderParameters));
        }
        return jsonObject;
    }

    private static JSONObject _getPortletStateJSONObject(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, LayoutTypePortlet layoutTypePortlet, Portlet portlet, Map<String, String[]> changedPublicRenderParameters) {
        return JSONUtil.put((String)"parameters", (Object)RenderStateUtil._getPortletParametersJSONObject(httpServletRequest, themeDisplay.getPlid(), portlet, changedPublicRenderParameters)).put("portletMode", (Object)RenderStateUtil._getPortletMode(layoutTypePortlet, portlet.getPortletId())).put("windowState", (Object)RenderStateUtil._getWindowState(layoutTypePortlet, portlet.getPortletId()));
    }

    private static JSONObject _getPRPGroupsJSONObject(List<Portlet> portlets) {
        LinkedHashMap<String, PRPGroup> map = new LinkedHashMap<String, PRPGroup>();
        for (Portlet portlet : portlets) {
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName());
                PRPGroup prpGroup = (PRPGroup)map.get(publicRenderParameterName);
                if (prpGroup == null) {
                    prpGroup = new PRPGroup(publicRenderParameter.getIdentifier(), new HashSet());
                }
                Set<String> portletIds = prpGroup.getPortletIds();
                portletIds.add(PortalUtil.getPortletNamespace((String)portlet.getPortletId()));
                map.put(publicRenderParameterName, prpGroup);
            }
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry entry : map.entrySet()) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            PRPGroup prpGroup = (PRPGroup)entry.getValue();
            for (String portletId : prpGroup.getPortletIds()) {
                String value = portletId.concat("|");
                jsonArray.put(value.concat(prpGroup.getIdentifier()));
            }
            jsonObject.put((String)entry.getKey(), jsonArray);
        }
        return jsonObject;
    }

    private static JSONObject _getRenderDataJSONObject(RenderData renderData) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (renderData == null) {
            jsonObject.put("content", "").put("mimeType", "");
        } else {
            jsonObject.put("content", renderData.getContent()).put("mimeType", renderData.getContentType());
        }
        return jsonObject;
    }

    private static WindowState _getWindowState(LayoutTypePortlet layoutTypePortlet, String portletId) {
        if (layoutTypePortlet.hasStateMaxPortletId(portletId)) {
            return WindowState.MAXIMIZED;
        }
        if (layoutTypePortlet.hasStateMinPortletId(portletId)) {
            return WindowState.MINIMIZED;
        }
        return WindowState.NORMAL;
    }

    private static class PRPGroup {
        private final String _identifier;
        private final Set<String> _portletIds;

        public String getIdentifier() {
            return this._identifier;
        }

        public Set<String> getPortletIds() {
            return this._portletIds;
        }

        private PRPGroup(String identifier, Set<String> portletIds) {
            this._identifier = identifier;
            this._portletIds = portletIds;
        }
    }
}

