/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.social.service.base.SocialRequestInterpreterLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.model.SocialRequestFeedEntry;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SocialRequestInterpreterLocalServiceImpl
extends SocialRequestInterpreterLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SocialRequestInterpreterLocalServiceImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final List<SocialRequestInterpreter> _requestInterpreters = new CopyOnWriteArrayList<SocialRequestInterpreter>();
    private ServiceTracker<SocialRequestInterpreter, SocialRequestInterpreter> _serviceTracker;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this._serviceTracker = new ServiceTracker(this._bundleContext, SystemBundleUtil.createFilter((String)("(&(javax.portlet.name=*)(objectClass=" + SocialRequestInterpreter.class.getName() + "))")), (ServiceTrackerCustomizer)new SocialRequestInterpreterServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public SocialRequestFeedEntry interpret(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            SocialRequestFeedEntry requestFeedEntry;
            SocialRequestInterpreterImpl socialRequestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(socialRequestInterpreterImpl, className, request) || (requestFeedEntry = socialRequestInterpreterImpl.interpret(request, themeDisplay)) == null) continue;
            requestFeedEntry.setPortletId(socialRequestInterpreterImpl.getPortletId());
            return requestFeedEntry;
        }
        return null;
    }

    public void processConfirmation(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            boolean value;
            SocialRequestInterpreterImpl socialRequestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(socialRequestInterpreterImpl, className, request) || !(value = socialRequestInterpreterImpl.processConfirmation(request, themeDisplay))) continue;
            return;
        }
    }

    public void processRejection(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            boolean value;
            SocialRequestInterpreterImpl socialRequestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(socialRequestInterpreterImpl, className, request) || !(value = socialRequestInterpreterImpl.processRejection(request, themeDisplay))) continue;
            return;
        }
    }

    protected String getSocialRequestPortletId(SocialRequest request) {
        try {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)request.getExtraData());
            return extraDataJSONObject.getString("portletId");
        }
        catch (JSONException jsonException) {
            _log.error((Object)("Unable to create JSON object from " + request.getExtraData()), (Throwable)jsonException);
            return "";
        }
    }

    protected boolean matches(SocialRequestInterpreterImpl socialRequestInterpreterImpl, String className, SocialRequest request) {
        if (!socialRequestInterpreterImpl.hasClassName(className)) {
            return false;
        }
        String requestPortletId = this.getSocialRequestPortletId(request);
        return Validator.isNull((String)requestPortletId) || requestPortletId.equals(socialRequestInterpreterImpl.getPortletId());
    }

    private class SocialRequestInterpreterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SocialRequestInterpreter, SocialRequestInterpreter> {
        private SocialRequestInterpreterServiceTrackerCustomizer() {
        }

        public SocialRequestInterpreter addingService(ServiceReference<SocialRequestInterpreter> serviceReference) {
            SocialRequestInterpreter requestInterpreter = (SocialRequestInterpreter)SocialRequestInterpreterLocalServiceImpl.this._bundleContext.getService(serviceReference);
            if (!(requestInterpreter instanceof SocialRequestInterpreterImpl)) {
                String portletId = (String)serviceReference.getProperty("javax.portlet.name");
                requestInterpreter = new SocialRequestInterpreterImpl(portletId, requestInterpreter);
            }
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.add(requestInterpreter);
            return requestInterpreter;
        }

        public void modifiedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
        }

        public void removedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
            SocialRequestInterpreterLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.remove(requestInterpreter);
        }
    }
}

