/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.LicenseUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateLicenseAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(UpdateLicenseAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this._isOmniAdmin(httpServletRequest)) {
            httpServletResponse.sendRedirect(PortalUtil.getPathContext() + "/c/portal/layout");
            return null;
        }
        if (StringUtil.equalsIgnoreCase((String)httpServletRequest.getMethod(), (String)"GET")) {
            return actionMapping.getActionForward("portal.license");
        }
        if (!this._isCSRFTokenValid(httpServletRequest, httpServletResponse)) {
            httpServletResponse.sendRedirect(PortalUtil.getPathContext() + "/c/portal/layout");
            return null;
        }
        LicenseUtil.registerOrder(httpServletRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
        String clusterNodeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"clusterNodeId");
        if (cmd.equals("licenseProperties")) {
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)this._getLicenseProperties(clusterNodeId));
            return null;
        }
        if (cmd.equals("serverInfo")) {
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)this._getServerInfo(clusterNodeId));
            return null;
        }
        return actionMapping.getActionForward("portal.license");
    }

    private String _getLicenseProperties(String clusterNodeId) {
        List licenseProperties = LicenseManagerUtil.getClusterLicenseProperties((String)clusterNodeId);
        if (licenseProperties == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map propertiesMap : licenseProperties) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                jsonObject.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    private String _getServerInfo(String clusterNodeId) throws Exception {
        Map<String, String> serverInfo = LicenseUtil.getClusterServerInfo(clusterNodeId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (serverInfo != null) {
            for (Map.Entry<String, String> entry : serverInfo.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jsonObject.toString();
    }

    private boolean _isCSRFTokenValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)httpServletRequest, (String)LicenseUtil.class.getName());
            return true;
        }
        catch (PortalException portalException) {
            _log.error((Object)"Invalid authentication token received", (Throwable)portalException);
            PortalUtil.sendError((int)401, (Exception)((Object)portalException), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return false;
        }
    }

    private boolean _isOmniAdmin(HttpServletRequest httpServletRequest) {
        User user;
        block2: {
            user = null;
            try {
                user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        return user != null && OmniadminUtil.isOmniadmin(user);
    }
}

