/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeployUtil {
    public static void copyDependencyXml(String fileName, String targetDir, String targetFileName, Map<String, String> filterMap, boolean overwrite) throws Exception {
        File targetFile = new File(targetDir, targetFileName);
        if (!targetFile.exists()) {
            HashSet<Path> tempPaths = new HashSet<Path>();
            File file = new File(DeployUtil.getResourcePath(tempPaths, fileName));
            String content = FileUtil.read((File)file);
            FileUtil.write((File)targetFile, (String)StringUtil.replace((String)content, (String)"@", (String)"@", filterMap));
            for (Path tempPath : tempPaths) {
                DeployUtil.deletePath(tempPath);
            }
        }
    }

    public static void deletePath(Path tempPath) throws IOException {
        Files.walkFileTree(tempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(filePath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String getResourcePath(Set<Path> tempDirPaths, String resource) throws Exception {
        InputStream inputStream = DeployUtil.class.getResourceAsStream("dependencies/" + resource);
        if (inputStream == null) {
            return null;
        }
        Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        tempDirPaths.add(tempDirPath);
        File file = new File(tempDirPath + "/liferay/com/liferay/portal/deploy/dependencies/" + resource);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            FileUtil.mkdirs((File)parentFile);
        }
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
        return FileUtil.getAbsolutePath((File)file);
    }
}

