/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;

public class GlobalShutdownAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(GlobalShutdownAction.class);

    public void run(String[] ids) {
        this.shutdownLevel1();
        this.shutdownLevel2();
        this.shutdownLevel3();
        this.shutdownLevel4();
        this.shutdownLevel5();
        this.shutdownLevel6();
        this.shutdownLevel7();
    }

    protected ThreadGroup getThreadGroup() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        for (int i = 0; i < 10 && threadGroup.getParent() != null; ++i) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    protected Thread[] getThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount() * 2];
        threadGroup.enumerate(threads);
        return threads;
    }

    protected void shutdownLevel1() {
        AuthPublicPathRegistry.unregister(PropsValues.AUTH_PUBLIC_PATHS);
    }

    protected void shutdownLevel2() {
        AutoDeployUtil.unregisterDir((String)"defaultAutoDeployDir");
        HotDeployUtil.unregisterListeners();
    }

    protected void shutdownLevel3() {
    }

    protected void shutdownLevel4() {
    }

    protected void shutdownLevel5() {
    }

    protected void shutdownLevel6() {
        block2: {
            try {
                LogFactoryUtil.setLogFactory((LogFactory)new Jdk14LogFactoryImpl());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        CentralizedThreadLocal.clearShortLivedThreadLocals();
    }

    protected void shutdownLevel7() {
        if (GetterUtil.getBoolean((String)PropsUtil.get("shutdown.programmatically.exit"))) {
            Thread[] threads;
            Thread currentThread = Thread.currentThread();
            ThreadGroup threadGroup = this.getThreadGroup();
            for (Thread thread : threads = this.getThreads(threadGroup)) {
                if (thread == null || thread == currentThread) continue;
                try {
                    thread.interrupt();
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)exception);
                }
            }
            threadGroup.destroy();
        }
    }
}

