/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.util;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class LocalRepositoryWrapper
implements LocalRepository {
    private volatile LocalRepository _localRepository;

    public LocalRepositoryWrapper(LocalRepository localRepository) {
        this._localRepository = localRepository;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(String externalReferenceCode, long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.addFileShortcut(externalReferenceCode, userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(String externalReferenceCode, long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.addFolder(externalReferenceCode, userId, parentFolderId, name, description, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._localRepository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._localRepository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
    }

    public void deleteAll() throws PortalException {
        this._localRepository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this._localRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this._localRepository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this._localRepository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        this._localRepository.deleteFileVersion(fileVersionId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this._localRepository.deleteFolder(folderId);
    }

    public FileEntry fetchFileEntry(long folderId, String title) throws PortalException {
        return this._localRepository.fetchFileEntry(folderId, title);
    }

    public FileEntry fetchFileEntryByExternalReferenceCode(String externalReferenceCode) {
        return this._localRepository.fetchFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public Folder fetchFolderByExternalReferenceCode(String externalReferenceCode) {
        return this._localRepository.fetchFolderByExternalReferenceCode(externalReferenceCode);
    }

    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T)this._localRepository.getCapability(capabilityClass);
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getFileEntries(folderId, status, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getFileEntries(folderId, mimeTypes, status, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this._localRepository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this._localRepository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        return this._localRepository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this._localRepository.getFileEntriesCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes, int status) throws PortalException {
        return this._localRepository.getFileEntriesCount(folderId, mimeTypes, status);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this._localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return this._localRepository.getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByExternalReferenceCode(String externalReferenceCode) throws PortalException {
        return this._localRepository.getFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public FileEntry getFileEntryByFileName(long folderId, String fileName) throws PortalException {
        return this._localRepository.getFileEntryByFileName(folderId, fileName);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return this._localRepository.getFileEntryByUuid(uuid);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this._localRepository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this._localRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return this._localRepository.getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return this._localRepository.getFolder(parentFolderId, name);
    }

    public Folder getFolderByExternalReferenceCode(String externalReferenceCode) throws PortalException {
        return this._localRepository.getFolderByExternalReferenceCode(externalReferenceCode);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._localRepository.getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._localRepository.getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this._localRepository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this._localRepository.getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    public long getRepositoryId() {
        return this._localRepository.getRepositoryId();
    }

    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return this._localRepository.isCapabilityProvided(capabilityClass);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._localRepository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    public void setLocalRepository(LocalRepository localRepository) {
        this._localRepository = localRepository;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this._localRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }
}

