/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthToken;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.SecurityPortletContainerWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _CSRF = "#CSRF";
    private static final byte[] _NULL_TOKEN = new byte[0];
    private static final Log _log = LogFactoryUtil.getLog(SessionAuthToken.class);

    public void addCSRFToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String lifecycle = liferayPortletURL.getLifecycle();
        if (!lifecycle.equals("ACTION_PHASE") || AuthTokenWhitelistUtil.isPortletURLCSRFWhitelisted((LiferayPortletURL)liferayPortletURL)) {
            return;
        }
        liferayPortletURL.setParameter("p_auth", this.getToken(httpServletRequest));
    }

    public void addPortletInvocationToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        String portletId;
        long plid;
        block7: {
            if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
                return;
            }
            plid = liferayPortletURL.getPlid();
            String key = PortletPermissionUtil.getPrimaryKey((long)plid, (String)(portletId = liferayPortletURL.getPortletId()));
            Object sessionAuthenticationToken = this._getSessionAuthenticationToken(httpServletRequest, key, false);
            if (sessionAuthenticationToken == _NULL_TOKEN) {
                return;
            }
            if (sessionAuthenticationToken instanceof String) {
                liferayPortletURL.setParameter("p_p_auth", (String)sessionAuthenticationToken);
                return;
            }
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), (String)portletId);
            if (portlet == null || !portlet.isAddDefaultResource() || AuthTokenWhitelistUtil.isPortletURLPortletInvocationWhitelisted((LiferayPortletURL)liferayPortletURL)) {
                this._setNullSessionAuthenticationToken(httpServletRequest, key);
                return;
            }
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    this._setNullSessionAuthenticationToken(httpServletRequest, key);
                    return;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)exception);
            }
        }
        liferayPortletURL.setParameter("p_p_auth", this.getToken(httpServletRequest, plid, portletId));
    }

    public void checkCSRFToken(HttpServletRequest httpServletRequest, String origin) throws PrincipalException {
        String ppid;
        Portlet portlet;
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String sharedSecret = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_auth_secret");
        if (AuthTokenWhitelistUtil.isValidSharedSecret((String)sharedSecret)) {
            return;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        if (AuthTokenWhitelistUtil.isOriginCSRFWhitelisted((long)companyId, (String)origin)) {
            return;
        }
        if (origin.equals(SecurityPortletContainerWrapper.class.getName()) && AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((HttpServletRequest)httpServletRequest, (Portlet)(portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)(ppid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id")))))) {
            return;
        }
        String sessionToken = this.getSessionAuthenticationToken(httpServletRequest, _CSRF, false);
        if (Validator.isNull((String)sessionToken)) {
            throw new PrincipalException.MustHaveSessionCSRFToken(PortalUtil.getUserId((HttpServletRequest)httpServletRequest), origin);
        }
        String csrfToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_auth");
        if (Validator.isNull((String)csrfToken)) {
            csrfToken = GetterUtil.getString((String)httpServletRequest.getHeader("X-CSRF-Token"));
        }
        if (!csrfToken.equals(sessionToken)) {
            throw new PrincipalException.MustHaveValidCSRFToken(PortalUtil.getUserId((HttpServletRequest)httpServletRequest), origin);
        }
    }

    public String getToken(HttpServletRequest httpServletRequest) {
        return this.getSessionAuthenticationToken(httpServletRequest, _CSRF, true);
    }

    public String getToken(HttpServletRequest httpServletRequest, long plid, String portletId) {
        return this.getSessionAuthenticationToken(httpServletRequest, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), true);
    }

    public boolean isValidPortletInvocationToken(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        String key;
        String sessionToken;
        if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted((HttpServletRequest)httpServletRequest, (Portlet)portlet)) {
            return true;
        }
        String portletToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_auth");
        if (Validator.isNull((String)portletToken)) {
            HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
            portletToken = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"p_p_auth");
        }
        return Validator.isNotNull((String)portletToken) && Validator.isNotNull((String)(sessionToken = this.getSessionAuthenticationToken(httpServletRequest, key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId()), false))) && sessionToken.equals(portletToken);
    }

    protected String getSessionAuthenticationToken(HttpServletRequest httpServletRequest, String key, boolean createToken) {
        Object sessionAuthenticationToken = this._getSessionAuthenticationToken(httpServletRequest, key, createToken);
        if (sessionAuthenticationToken instanceof String) {
            return (String)sessionAuthenticationToken;
        }
        return null;
    }

    private Object _getSessionAuthenticationToken(HttpServletRequest httpServletRequest, String key, boolean createToken) {
        Object sessionAuthenticationToken = null;
        String authenticationTokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        HttpSession httpSession = null;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper && (sessionAuthenticationToken = (httpSession = currentHttpServletRequest.getSession()).getAttribute(authenticationTokenKey)) == null) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (sessionAuthenticationToken == null) {
            httpSession = currentHttpServletRequest.getSession();
            sessionAuthenticationToken = httpSession.getAttribute(authenticationTokenKey);
        }
        if (createToken && (sessionAuthenticationToken == null || sessionAuthenticationToken == _NULL_TOKEN)) {
            sessionAuthenticationToken = PwdGenerator.getPassword((int)PropsValues.AUTH_TOKEN_LENGTH);
            httpSession.setAttribute(authenticationTokenKey, sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }

    private void _setNullSessionAuthenticationToken(HttpServletRequest httpServletRequest, String key) {
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        String authenticationTokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        httpSession.setAttribute(authenticationTokenKey, (Object)_NULL_TOKEN);
    }
}

