/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.session;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.encryptor.EncryptorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.RememberMeToken;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.RememberMeTokenLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.util.PropsValues;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticatedSessionManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(AuthenticatedSessionManagerUtil.class);

    public static long getAuthenticatedUserId(HttpServletRequest httpServletRequest, String login, String password, String authType) throws PortalException {
        User user = AuthenticatedSessionManagerUtil._getAuthenticatedUser(httpServletRequest, login, password, authType);
        return user.getUserId();
    }

    public static void login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String login, String password, boolean rememberMe, String authType) throws Exception {
        String domain;
        String queryString = HttpComponentsUtil.getQueryString((HttpServletRequest)(httpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest)));
        if (Validator.isNotNull((String)queryString) && queryString.contains("password=")) {
            int index;
            String passwordParameterName = "password=";
            String portletId = PortalUtil.getPortletId((HttpServletRequest)httpServletRequest);
            if (portletId != null) {
                passwordParameterName = PortalUtil.getPortletNamespace((String)portletId) + passwordParameterName;
            }
            if ((index = queryString.indexOf(passwordParameterName)) == 0 || index > 0 && queryString.charAt(index - 1) == '&') {
                if (_log.isWarnEnabled()) {
                    String referer = httpServletRequest.getHeader("Referer");
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Ignoring login attempt because the password ", "parameter was found for the request with the ", "referer header: ", referer}));
                }
                return;
            }
        }
        CookiesManagerUtil.validateSupportCookie((HttpServletRequest)httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        User user = AuthenticatedSessionManagerUtil._getAuthenticatedUser(httpServletRequest, login, password, authType);
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            AuthenticatedSessionManagerUtil.signOutSimultaneousLogins(user.getUserId());
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            httpSession = AuthenticatedSessionManagerUtil.renewSession(httpServletRequest, httpSession);
        }
        if (Validator.isNull((String)(domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest)))) {
            domain = null;
        }
        String userIdString = String.valueOf(user.getUserId());
        httpSession.setAttribute("j_username", (Object)userIdString);
        if (PropsValues.PORTAL_JAAS_PLAIN_PASSWORD) {
            httpSession.setAttribute("j_password", (Object)password);
        } else {
            httpSession.setAttribute("j_password", (Object)user.getPassword());
        }
        httpSession.setAttribute("j_remoteuser", (Object)userIdString);
        if (PropsValues.SESSION_STORE_PASSWORD) {
            httpSession.setAttribute("USER_PASSWORD", (Object)password);
        }
        Cookie companyIdCookie = new Cookie("COMPANY_ID", String.valueOf(company.getCompanyId()));
        if (domain != null) {
            companyIdCookie.setDomain(domain);
        }
        Cookie idCookie = new Cookie("ID", EncryptorUtil.encrypt((Key)company.getKeyObj(), (String)userIdString));
        if (domain != null) {
            idCookie.setDomain(domain);
        }
        int loginMaxAge = PropsValues.COMPANY_SECURITY_AUTO_LOGIN_MAX_AGE;
        if (rememberMe) {
            companyIdCookie.setMaxAge(loginMaxAge);
            idCookie.setMaxAge(loginMaxAge);
        } else {
            companyIdCookie.setMaxAge(-1);
            idCookie.setMaxAge(-1);
        }
        CookiesManagerUtil.addCookie((int)2, (Cookie)companyIdCookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        CookiesManagerUtil.addCookie((int)2, (Cookie)idCookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        if (rememberMe) {
            CookiesManagerUtil.addCookie((int)1, (Cookie)AuthenticatedSessionManagerUtil._createCookie("LOGIN", login, domain, loginMaxAge), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            CookiesManagerUtil.addCookie((int)1, (Cookie)AuthenticatedSessionManagerUtil._createCookie("REMEMBER_ME", Boolean.TRUE.toString(), domain, loginMaxAge), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            Cookie cookie = AuthenticatedSessionManagerUtil._createCookie("REMEMBER_ME_TOKEN_VALUE", "", domain, loginMaxAge);
            RememberMeToken rememberMeToken = RememberMeTokenLocalServiceUtil.addRememberMeToken((long)user.getCompanyId(), (long)user.getUserId(), (Date)new Date(System.currentTimeMillis() + (long)loginMaxAge * 1000L), arg_0 -> ((Cookie)cookie).setValue(arg_0));
            CookiesManagerUtil.addCookie((int)1, (Cookie)AuthenticatedSessionManagerUtil._createCookie("REMEMBER_ME_TOKEN_ID", String.valueOf(rememberMeToken.getRememberMeTokenId()), domain, loginMaxAge), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            CookiesManagerUtil.addCookie((int)1, (Cookie)cookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    public static void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        block5: {
            RememberMeToken rememberMeToken;
            String rememberMeTokenId;
            HttpSession httpSession = httpServletRequest.getSession();
            EventsProcessorUtil.process("logout.events.pre", PropsValues.LOGOUT_EVENTS_PRE, httpServletRequest, httpServletResponse);
            String domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest);
            if (Validator.isNull((String)domain)) {
                domain = null;
            }
            if (!GetterUtil.getBoolean((String)CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME", (HttpServletRequest)httpServletRequest, (boolean)false))) {
                CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"LOGIN"});
            }
            if (Validator.isNotNull((String)(rememberMeTokenId = CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME_TOKEN_ID", (HttpServletRequest)httpServletRequest))) && (rememberMeToken = RememberMeTokenLocalServiceUtil.fetchRememberMeToken((long)GetterUtil.getLong((String)rememberMeTokenId))) != null) {
                RememberMeTokenLocalServiceUtil.deleteRememberMeToken((RememberMeToken)rememberMeToken);
            }
            CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"COMPANY_ID", "GUEST_LANGUAGE_ID", "ID", "PASSWORD", "REMEMBER_ME", "REMEMBER_ME_TOKEN_ID", "REMEMBER_ME_TOKEN_VALUE"});
            try {
                httpSession.invalidate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        EventsProcessorUtil.process("logout.events.post", PropsValues.LOGOUT_EVENTS_POST, httpServletRequest, httpServletResponse);
    }

    public static HttpSession renewSession(HttpServletRequest httpServletRequest, HttpSession httpSession) throws Exception {
        Object protectedAttributeValue;
        String[] protectedAttributeNames = PropsValues.SESSION_PHISHING_PROTECTED_ATTRIBUTES;
        HashMap<String, Object> protectedAttributes = new HashMap<String, Object>();
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = httpSession.getAttribute(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            protectedAttributes.put(protectedAttributeName, protectedAttributeValue);
        }
        httpSession.invalidate();
        httpSession = httpServletRequest.getSession(true);
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = protectedAttributes.get(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            httpSession.setAttribute(protectedAttributeName, protectedAttributeValue);
        }
        return httpSession;
    }

    public static void signOutSimultaneousLogins(long userId) throws Exception {
        long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
        Map<String, UserTracker> sessionUsers = LiveUsers.getSessionUsers(companyId);
        ArrayList<UserTracker> userTrackers = new ArrayList<UserTracker>(sessionUsers.values());
        for (UserTracker userTracker : userTrackers) {
            if (userId != userTracker.getUserId()) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
            if (clusterNode != null) {
                jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
            }
            jsonObject.put("command", "signOut").put("companyId", companyId).put("sessionId", userTracker.getSessionId()).put("userId", userId);
            MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
        }
    }

    private static Cookie _createCookie(String name, String value, String domain, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAge);
        return cookie;
    }

    private static User _getAuthenticatedUser(HttpServletRequest httpServletRequest, String login, String password, String authType) throws PortalException {
        String contextPath;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.startsWith((contextPath = PortalUtil.getPathContext()).concat("/api/liferay"))) {
            throw new AuthException();
        }
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        HashMap<String, String[]> headerMap = new HashMap<String, String[]>();
        Enumeration enumeration1 = httpServletRequest.getHeaderNames();
        while (enumeration1.hasMoreElements()) {
            String name = (String)enumeration1.nextElement();
            Enumeration enumeration2 = httpServletRequest.getHeaders(name);
            ArrayList<String> headers = new ArrayList<String>();
            while (enumeration2.hasMoreElements()) {
                String value = (String)enumeration2.nextElement();
                headers.add(value);
            }
            headerMap.put(name, headers.toArray(new String[0]));
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        HashMap resultsMap = new HashMap();
        if (Validator.isNull((String)authType)) {
            authType = company.getAuthType();
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)GetterUtil.getLong((String)login), (String)password, headerMap, (Map)parameterMap, resultsMap);
        }
        if (authResult != 1) {
            throw new AuthException();
        }
        return (User)resultsMap.get("user");
    }

    private AuthenticatedSessionManagerUtil() {
    }
}

