/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.EmailAddressPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

public abstract class EmailAddressLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements EmailAddressLocalService,
IdentifiableOSGiService {
    @BeanReference(type=EmailAddressLocalService.class)
    protected EmailAddressLocalService emailAddressLocalService;
    @BeanReference(type=EmailAddressPersistence.class)
    protected EmailAddressPersistence emailAddressPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(EmailAddressLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public EmailAddress addEmailAddress(EmailAddress emailAddress) {
        emailAddress.setNew(true);
        return (EmailAddress)this.emailAddressPersistence.update((BaseModel)emailAddress);
    }

    @Transactional(enabled=false)
    public EmailAddress createEmailAddress(long emailAddressId) {
        return this.emailAddressPersistence.create(emailAddressId);
    }

    @Indexable(type=IndexableType.DELETE)
    public EmailAddress deleteEmailAddress(long emailAddressId) throws PortalException {
        return this.emailAddressPersistence.remove(emailAddressId);
    }

    @Indexable(type=IndexableType.DELETE)
    public EmailAddress deleteEmailAddress(EmailAddress emailAddress) {
        return (EmailAddress)this.emailAddressPersistence.remove((BaseModel)emailAddress);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.emailAddressPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(EmailAddress.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.emailAddressPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.emailAddressPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.emailAddressPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.emailAddressPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.emailAddressPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public EmailAddress fetchEmailAddress(long emailAddressId) {
        return this.emailAddressPersistence.fetchByPrimaryKey(emailAddressId);
    }

    public EmailAddress fetchEmailAddressByUuidAndCompanyId(String uuid, long companyId) {
        return this.emailAddressPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public EmailAddress getEmailAddress(long emailAddressId) throws PortalException {
        return this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.emailAddressLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(EmailAddress.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("emailAddressId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.emailAddressLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(EmailAddress.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("emailAddressId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.emailAddressLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(EmailAddress.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("emailAddressId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<EmailAddress>(){

            public void performAction(EmailAddress emailAddress) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)emailAddress);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)EmailAddress.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.emailAddressPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement EmailAddressLocalServiceImpl#deleteEmailAddress(EmailAddress) to avoid orphaned data");
        }
        return this.emailAddressLocalService.deleteEmailAddress((EmailAddress)persistedModel);
    }

    public BasePersistence<EmailAddress> getBasePersistence() {
        return this.emailAddressPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.emailAddressPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public EmailAddress getEmailAddressByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.emailAddressPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<EmailAddress> getEmailAddresses(int start, int end) {
        return this.emailAddressPersistence.findAll(start, end);
    }

    public int getEmailAddressesCount() {
        return this.emailAddressPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public EmailAddress updateEmailAddress(EmailAddress emailAddress) {
        return (EmailAddress)this.emailAddressPersistence.update((BaseModel)emailAddress);
    }

    public EmailAddressLocalService getEmailAddressLocalService() {
        return this.emailAddressLocalService;
    }

    public void setEmailAddressLocalService(EmailAddressLocalService emailAddressLocalService) {
        this.emailAddressLocalService = emailAddressLocalService;
    }

    public EmailAddressPersistence getEmailAddressPersistence() {
        return this.emailAddressPersistence;
    }

    public void setEmailAddressPersistence(EmailAddressPersistence emailAddressPersistence) {
        this.emailAddressPersistence = emailAddressPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        EmailAddressLocalServiceUtil.setService((EmailAddressLocalService)this.emailAddressLocalService);
    }

    public void destroy() {
        EmailAddressLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return EmailAddressLocalService.class.getName();
    }

    public CTPersistence<EmailAddress> getCTPersistence() {
        return this.emailAddressPersistence;
    }

    public Class<EmailAddress> getModelClass() {
        return EmailAddress.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<EmailAddress>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.emailAddressPersistence);
    }

    protected String getModelClassName() {
        return EmailAddress.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.emailAddressPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

