/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.AddressServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;

public class AddressServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AddressServiceHttp.class);
    private static final Class<?>[] _addAddressParameterTypes0 = new Class[]{String.class, String.class, Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteAddressParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getAddressParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getAddressesParameterTypes3 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _getListTypeAddressesParameterTypes4 = new Class[]{String.class, Long.TYPE, long[].class};
    private static final Class<?>[] _updateAddressParameterTypes5 = new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, String.class};
    private static final Class<?>[] _updateExternalReferenceCodeParameterTypes6 = new Class[]{Address.class, String.class};
    private static final Class<?>[] _updateExternalReferenceCodeParameterTypes7 = new Class[]{Long.TYPE, String.class};

    public static Address addAddress(HttpPrincipal httpPrincipal, String externalReferenceCode, String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "addAddress", (Class[])_addAddressParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary, phoneNumber, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Address)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteAddress(HttpPrincipal httpPrincipal, long addressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "deleteAddress", (Class[])_deleteAddressParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{addressId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Address getAddress(HttpPrincipal httpPrincipal, long addressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "getAddress", (Class[])_getAddressParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{addressId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Address)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Address> getAddresses(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "getAddresses", (Class[])_getAddressesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Address> getListTypeAddresses(HttpPrincipal httpPrincipal, String className, long classPK, long[] listTypeIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "getListTypeAddresses", (Class[])_getListTypeAddressesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, listTypeIds});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Address updateAddress(HttpPrincipal httpPrincipal, long addressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary, String phoneNumber) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "updateAddress", (Class[])_updateAddressParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{addressId, name, description, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary, phoneNumber});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Address)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Address updateExternalReferenceCode(HttpPrincipal httpPrincipal, Address address, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "updateExternalReferenceCode", (Class[])_updateExternalReferenceCodeParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{address, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Address)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Address updateExternalReferenceCode(HttpPrincipal httpPrincipal, long addressId, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "updateExternalReferenceCode", (Class[])_updateExternalReferenceCodeParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{addressId, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Address)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

