/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceHttp.class);
    private static final Class<?>[] _addRoleParameterTypes0 = new Class[]{String.class, String.class, Long.TYPE, String.class, Map.class, Map.class, Integer.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addUserRolesParameterTypes1 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _deleteRoleParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchRoleParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchRoleParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _fetchRoleByExternalReferenceCodeParameterTypes5 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _getGroupRolesParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupRolesAndTeamRolesParameterTypes7 = new Class[]{Long.TYPE, String.class, List.class, String.class, String.class, int[].class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupRolesAndTeamRolesCountParameterTypes8 = new Class[]{Long.TYPE, String.class, List.class, String.class, String.class, int[].class, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes9 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes10 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getRolesParameterTypes11 = new Class[]{Integer.TYPE, String.class};
    private static final Class<?>[] _getRolesParameterTypes12 = new Class[]{Long.TYPE, int[].class};
    private static final Class<?>[] _getUserGroupGroupRolesParameterTypes13 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserGroupRolesParameterTypes14 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserRelatedRolesParameterTypes15 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getUserRolesParameterTypes16 = new Class[]{Long.TYPE};
    private static final Class<?>[] _hasUserRoleParameterTypes17 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE};
    private static final Class<?>[] _hasUserRolesParameterTypes18 = new Class[]{Long.TYPE, Long.TYPE, String[].class, Boolean.TYPE};
    private static final Class<?>[] _searchParameterTypes19 = new Class[]{Long.TYPE, String.class, Integer[].class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes20 = new Class[]{Long.TYPE, String.class, Integer[].class, LinkedHashMap.class};
    private static final Class<?>[] _unsetUserRolesParameterTypes21 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateExternalReferenceCodeParameterTypes22 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateExternalReferenceCodeParameterTypes23 = new Class[]{Role.class, String.class};
    private static final Class<?>[] _updateRoleParameterTypes24 = new Class[]{Long.TYPE, String.class, Map.class, Map.class, String.class, ServiceContext.class};

    public static Role addRole(HttpPrincipal httpPrincipal, String externalReferenceCode, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "addRole", (Class[])_addRoleParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, className, classPK, name, titleMap, descriptionMap, type, subtype, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void addUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "addUserRoles", (Class[])_addUserRolesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "deleteRole", (Class[])_deleteRoleParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role fetchRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "fetchRole", (Class[])_fetchRoleParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role fetchRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "fetchRole", (Class[])_fetchRoleParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role fetchRoleByExternalReferenceCode(HttpPrincipal httpPrincipal, String externalReferenceCode, long companyId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "fetchRoleByExternalReferenceCode", (Class[])_fetchRoleByExternalReferenceCodeParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getGroupRoles(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRoles", (Class[])_getGroupRolesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getGroupRolesAndTeamRoles(HttpPrincipal httpPrincipal, long companyId, String name, List<String> excludedNames, String title, String description, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRolesAndTeamRoles", (Class[])_getGroupRolesAndTeamRolesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, excludedNames, title, description, types, excludedTeamRoleId, teamGroupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getGroupRolesAndTeamRolesCount(HttpPrincipal httpPrincipal, long companyId, String name, List<String> excludedNames, String title, String description, int[] types, long excludedTeamRoleId, long teamGroupId) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getGroupRolesAndTeamRolesCount", (Class[])_getGroupRolesAndTeamRolesCountParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, excludedNames, title, description, types, excludedTeamRoleId, teamGroupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRole", (Class[])_getRoleParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRole", (Class[])_getRoleParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getRoles(HttpPrincipal httpPrincipal, int type, String subtype) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRoles", (Class[])_getRolesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{type, subtype});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getRoles(HttpPrincipal httpPrincipal, long companyId, int[] types) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getRoles", (Class[])_getRolesParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, types});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getUserGroupGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserGroupGroupRoles", (Class[])_getUserGroupGroupRolesParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getUserGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserGroupRoles", (Class[])_getUserGroupRolesParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getUserRelatedRoles(HttpPrincipal httpPrincipal, long userId, List<Group> groups) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserRelatedRoles", (Class[])_getUserRelatedRolesParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> getUserRoles(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "getUserRoles", (Class[])_getUserRolesParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static boolean hasUserRole(HttpPrincipal httpPrincipal, long userId, long companyId, String name, boolean inherited) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "hasUserRole", (Class[])_hasUserRoleParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, name, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static boolean hasUserRoles(HttpPrincipal httpPrincipal, long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "hasUserRoles", (Class[])_hasUserRolesParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, names, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Role> search(HttpPrincipal httpPrincipal, long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> orderByComparator) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "search", (Class[])_searchParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, keywords, types, params, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "searchCount", (Class[])_searchCountParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, keywords, types, params});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unsetUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "unsetUserRoles", (Class[])_unsetUserRolesParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role updateExternalReferenceCode(HttpPrincipal httpPrincipal, long roleId, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "updateExternalReferenceCode", (Class[])_updateExternalReferenceCodeParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role updateExternalReferenceCode(HttpPrincipal httpPrincipal, Role role, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "updateExternalReferenceCode", (Class[])_updateExternalReferenceCodeParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{role, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Role updateRole(HttpPrincipal httpPrincipal, long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class, "updateRole", (Class[])_updateRoleParameterTypes24);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, name, titleMap, descriptionMap, subtype, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Role)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

