/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.service.util.PortalPreferencesCacheUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.PortalPreferenceValueLocalService;
import com.liferay.portal.kernel.service.persistence.PortalPreferenceValuePersistence;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortalPreferencesLocalServiceBaseImpl;
import com.liferay.portal.service.impl.PortalPreferenceValueLocalServiceImpl;
import com.liferay.portlet.PortalPreferenceKey;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;

public class PortalPreferencesLocalServiceImpl
extends PortalPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalPreferencesLocalServiceImpl.class);
    @BeanReference(type=PortalPreferenceValueLocalService.class)
    private PortalPreferenceValueLocalService _portalPreferenceValueLocalService;
    @BeanReference(type=PortalPreferenceValuePersistence.class)
    private PortalPreferenceValuePersistence _portalPreferenceValuePersistence;

    public com.liferay.portal.kernel.model.PortalPreferences addPortalPreferences(long ownerId, int ownerType, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences;
        block7: {
            com.liferay.portal.kernel.model.PortalPreferences previousPortalPreferences = this.fetchPortalPreferences(ownerId, ownerType);
            if (previousPortalPreferences != null) {
                throw new IllegalArgumentException("Duplicate owner ID and owner type exists in " + previousPortalPreferences);
            }
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = "<portlet-preferences />";
            }
            if (Objects.equals("<portlet-preferences />", defaultPreferences)) {
                PortalPreferencesCacheUtil.put(portalPreferencesId, Collections.emptyMap());
            } else {
                PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)defaultPreferences);
                this._updatePortalPreferences(portalPreferences, Collections.emptyMap(), portalPreferencesImpl.getPreferences());
            }
            try {
                portalPreferences = (com.liferay.portal.kernel.model.PortalPreferences)this.portalPreferencesPersistence.update((BaseModel)portalPreferences);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {ownerId=", ownerId, ", ownerType=", ownerType, "}"}));
                }
                if ((portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType, false)) != null) break block7;
                throw systemException;
            }
        }
        return portalPreferences;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public com.liferay.portal.kernel.model.PortalPreferences deletePortalPreferences(long portalPreferencesId) throws PortalException {
        this._portalPreferenceValuePersistence.removeByPortalPreferencesId(portalPreferencesId);
        return super.deletePortalPreferences(portalPreferencesId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public com.liferay.portal.kernel.model.PortalPreferences deletePortalPreferences(com.liferay.portal.kernel.model.PortalPreferences portalPreferences) {
        this._portalPreferenceValuePersistence.removeByPortalPreferencesId(portalPreferences.getPortalPreferencesId());
        return super.deletePortalPreferences(portalPreferences);
    }

    public com.liferay.portal.kernel.model.PortalPreferences fetchPortalPreferences(long ownerId, int ownerType) {
        if (ownerType == 1) {
            for (com.liferay.portal.kernel.model.PortalPreferences portalPreferences : this.portalPreferencesPersistence.findByOwnerType(1)) {
                if (portalPreferences.getOwnerId() != ownerId) continue;
                return portalPreferences;
            }
            return null;
        }
        return this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType) {
        return this.getPreferences(ownerId, ownerType, null);
    }

    public PortletPreferences getPreferences(long ownerId, int ownerType, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this.fetchPortalPreferences(ownerId, ownerType);
        if (portalPreferences == null) {
            portalPreferences = this.portalPreferencesLocalService.addPortalPreferences(ownerId, ownerType, defaultPreferences);
        }
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)this._portalPreferenceValueLocalService.getPortalPreferences(portalPreferences, false);
        return new PortalPreferencesWrapper(portalPreferencesImpl);
    }

    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, PortalPreferences portalPreferences) {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)portalPreferences;
        return this._updatePortalPreferences(ownerId, ownerType, portalPreferencesImpl.getPreferences());
    }

    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, String xml) {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)xml);
        return this._updatePortalPreferences(ownerId, ownerType, portalPreferencesImpl.getPreferences());
    }

    private com.liferay.portal.kernel.model.PortalPreferences _updatePortalPreferences(long ownerId, int ownerType, Map<PortalPreferenceKey, String[]> preferencesMap) {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferencesModel = this.fetchPortalPreferences(ownerId, ownerType);
        Map<PortalPreferenceKey, List<PortalPreferenceValue>> portalPreferenceValuesMap = Collections.emptyMap();
        if (portalPreferencesModel == null) {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferencesModel = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferencesModel.setOwnerId(ownerId);
            portalPreferencesModel.setOwnerType(ownerType);
            portalPreferencesModel = (com.liferay.portal.kernel.model.PortalPreferences)this.portalPreferencesPersistence.update((BaseModel)portalPreferencesModel);
        } else {
            portalPreferenceValuesMap = PortalPreferenceValueLocalServiceImpl.getPortalPreferenceValuesMap(this._portalPreferenceValuePersistence, portalPreferencesModel.getPortalPreferencesId(), true);
        }
        this._updatePortalPreferences(portalPreferencesModel, portalPreferenceValuesMap, preferencesMap);
        return portalPreferencesModel;
    }

    private void _updatePortalPreferences(com.liferay.portal.kernel.model.PortalPreferences portalPreferences, Map<PortalPreferenceKey, List<PortalPreferenceValue>> portalPreferenceValueMap, Map<PortalPreferenceKey, String[]> preferencesMap) {
        List portalPreferenceValues;
        ArrayList<AbstractMap.SimpleImmutableEntry<List, PortalPreference>> preferenceEntries = new ArrayList<AbstractMap.SimpleImmutableEntry<List, PortalPreference>>(preferencesMap.size());
        int newCount = 0;
        for (Map.Entry<PortalPreferenceKey, String[]> entry : preferencesMap.entrySet()) {
            String[] values = entry.getValue();
            if (values == null) continue;
            int n = 0;
            portalPreferenceValues = portalPreferenceValueMap.remove(entry.getKey());
            if (portalPreferenceValues != null) {
                n = portalPreferenceValues.size();
            }
            if (values.length > n) {
                newCount += values.length - n;
            }
            preferenceEntries.add(new AbstractMap.SimpleImmutableEntry<List, PortalPreference>(portalPreferenceValues, new PortalPreference(entry.getKey(), values)));
        }
        for (List list : portalPreferenceValueMap.values()) {
            for (PortalPreferenceValue portalPreferenceValue : list) {
                this._portalPreferenceValuePersistence.remove((BaseModel)portalPreferenceValue);
            }
        }
        long batchCounter = 0L;
        if (newCount > 0) {
            batchCounter = this.counterLocalService.increment(PortalPreferenceValue.class.getName(), newCount);
            batchCounter -= (long)newCount;
        }
        for (Map.Entry entry : preferenceEntries) {
            int i;
            portalPreferenceValues = (List)entry.getKey();
            PortalPreference portalPreference = (PortalPreference)entry.getValue();
            PortalPreferenceKey portalPreferenceKey = portalPreference._portalPreferenceKey;
            String[] newValues = portalPreference._values;
            int oldSize = 0;
            if (portalPreferenceValues != null) {
                oldSize = portalPreferenceValues.size();
            }
            for (i = 0; i < newValues.length; ++i) {
                PortalPreferenceValue portalPreferenceValue;
                String value = newValues[i];
                if (oldSize > i) {
                    portalPreferenceValue = (PortalPreferenceValue)portalPreferenceValues.get(i);
                    if (Objects.equals(newValues[i], portalPreferenceValue.getValue())) continue;
                    portalPreferenceValue.setValue(value);
                    this._portalPreferenceValuePersistence.update((BaseModel)portalPreferenceValue);
                    continue;
                }
                portalPreferenceValue = this._portalPreferenceValuePersistence.create(++batchCounter);
                portalPreferenceValue.setPortalPreferencesId(portalPreferences.getPortalPreferencesId());
                portalPreferenceValue.setIndex(i);
                portalPreferenceValue.setKey(portalPreferenceKey.getKey());
                portalPreferenceValue.setNamespace(portalPreferenceKey.getNamespace());
                portalPreferenceValue.setValue(value);
                this._portalPreferenceValuePersistence.update((BaseModel)portalPreferenceValue);
            }
            for (i = newValues.length; i < oldSize; ++i) {
                this._portalPreferenceValuePersistence.remove((BaseModel)portalPreferenceValues.get(i));
            }
        }
        PortalPreferencesCacheUtil.put(portalPreferences.getPortalPreferencesId(), preferencesMap);
    }

    private static class PortalPreference {
        private final PortalPreferenceKey _portalPreferenceKey;
        private final String[] _values;

        private PortalPreference(PortalPreferenceKey portalPreferenceKey, String[] values) {
            this._portalPreferenceKey = portalPreferenceKey;
            this._values = values;
        }
    }
}

