/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.membershippolicy.RoleMembershipPolicyUtil;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.service.base.RoleServiceBaseImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RoleServiceImpl
extends RoleServiceBaseImpl {
    public Role addRole(String externalReferenceCode, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ROLE");
        User user = this.getUser();
        Role role = this.roleLocalService.addRole(externalReferenceCode, user.getUserId(), className, classPK, name, titleMap, descriptionMap, type, subtype, serviceContext);
        if (type == 3) {
            OrganizationMembershipPolicyUtil.verifyPolicy((Role)role);
        } else if (type == 2) {
            SiteMembershipPolicyUtil.verifyPolicy(role);
        } else {
            RoleMembershipPolicyUtil.verifyPolicy(role);
        }
        return role;
    }

    public void addUserRoles(long userId, long[] roleIds) throws PortalException {
        if (roleIds.length == 0) {
            return;
        }
        this.checkUserRolesPermission(userId, roleIds);
        RoleMembershipPolicyUtil.checkRoles(new long[]{userId}, roleIds, null);
        this.roleLocalService.addUserRoles(userId, roleIds);
        RoleMembershipPolicyUtil.propagateRoles(new long[]{userId}, roleIds, null);
    }

    public void deleteRole(long roleId) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"DELETE");
        this.roleLocalService.deleteRole(roleId);
    }

    public Role fetchRole(long roleId) throws PortalException {
        Role role = this.roleLocalService.fetchRole(roleId);
        if (role != null) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        }
        return role;
    }

    public Role fetchRole(long companyId, String name) throws PortalException {
        Role role = this.roleLocalService.fetchRole(companyId, name);
        if (role != null) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW");
        }
        return role;
    }

    public Role fetchRoleByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        Role role = this.roleLocalService.fetchRoleByExternalReferenceCode(externalReferenceCode, companyId);
        if (role != null) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW");
        }
        return role;
    }

    public List<Role> getGroupRoles(long groupId) throws PortalException {
        List roles = this.roleLocalService.getGroupRoles(groupId);
        return this.filterRoles(roles);
    }

    public List<Role> getGroupRolesAndTeamRoles(long companyId, String name, List<String> excludedNames, String title, String description, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) {
        return this.roleFinder.filterFindByGroupRoleAndTeamRole(companyId, name, excludedNames, title, description, types, excludedTeamRoleId, teamGroupId, start, end);
    }

    public int getGroupRolesAndTeamRolesCount(long companyId, String name, List<String> excludedNames, String title, String description, int[] types, long excludedTeamRoleId, long teamGroupId) {
        return this.roleFinder.filterCountByGroupRoleAndTeamRole(companyId, name, excludedNames, title, description, types, excludedTeamRoleId, teamGroupId);
    }

    public Role getRole(long roleId) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        return this.roleLocalService.getRole(roleId);
    }

    public Role getRole(long companyId, String name) throws PortalException {
        Role role = this.roleLocalService.getRole(companyId, name);
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW");
        return role;
    }

    public List<Role> getRoles(int type, String subtype) throws PortalException {
        return this.filterRoles(this.roleLocalService.getRoles(type, subtype));
    }

    public List<Role> getRoles(long companyId, int[] types) throws PortalException {
        return this.filterRoles(this.roleLocalService.getRoles(companyId, types));
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserGroupGroupRoles(userId, groupId);
        return this.filterRoles(roles);
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserGroupRoles(userId, groupId);
        return this.filterRoles(roles);
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserRelatedRoles(userId, groups);
        return this.filterRoles(roles);
    }

    public List<Role> getUserRoles(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List roles = this.roleLocalService.getUserRoles(userId);
        return this.filterRoles(roles);
    }

    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.roleLocalService.hasUserRoles(userId, companyId, names, inherited);
    }

    public List<Role> search(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> orderByComparator) {
        return this.roleFinder.filterFindByKeywords(companyId, keywords, types, params, start, end, orderByComparator);
    }

    public int searchCount(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.filterCountByKeywords(companyId, keywords, types, params);
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException {
        if (roleIds.length == 0) {
            return;
        }
        this.checkUserRolesPermission(userId, roleIds);
        RoleMembershipPolicyUtil.checkRoles(new long[]{userId}, null, roleIds);
        this.roleLocalService.unsetUserRoles(userId, roleIds);
        RoleMembershipPolicyUtil.propagateRoles(new long[]{userId}, null, roleIds);
    }

    public Role updateExternalReferenceCode(long roleId, String externalReferenceCode) throws PortalException {
        return this.updateExternalReferenceCode(this.getRole(roleId), externalReferenceCode);
    }

    public Role updateExternalReferenceCode(Role role, String externalReferenceCode) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"UPDATE");
        return this.roleLocalService.updateExternalReferenceCode(role, externalReferenceCode);
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        Role oldRole = this.rolePersistence.findByPrimaryKey(roleId);
        ExpandoBridge oldExpandoBridge = oldRole.getExpandoBridge();
        Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
        Role role = this.roleLocalService.updateRole(roleId, name, titleMap, descriptionMap, subtype, serviceContext);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.verifyPolicy((Role)role, (Role)oldRole, (Map)oldExpandoAttributes);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.verifyPolicy(role, oldRole, oldExpandoAttributes);
        } else {
            RoleMembershipPolicyUtil.verifyPolicy(role, oldRole, oldExpandoAttributes);
        }
        return role;
    }

    protected void checkUserRolesPermission(long userId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        }
    }

    protected List<Role> filterRoles(List<Role> roles) throws PortalException {
        ArrayList<Role> filteredRoles = new ArrayList<Role>();
        for (Role role : roles) {
            if (!RolePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW")) continue;
            filteredRoles.add(role);
        }
        return filteredRoles;
    }
}

