/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.BrowserMetadata;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;

public class BrowserSnifferUtil {
    public static final String BROWSER_ID_CHROME = "chrome";
    public static final String BROWSER_ID_EDGE = "edge";
    public static final String BROWSER_ID_FIREFOX = "firefox";
    public static final String BROWSER_ID_IE = "ie";
    public static final String BROWSER_ID_OTHER = "other";
    private static final String[] _REVISION_LEADINGS = new String[]{"rv", "it", "ra", "trident", "ie"};
    private static final char[] _REVISION_SEPARATORS = new char[]{'\\', ':', '/', ' '};
    private static final String[] _VERSION_LEADINGS = new String[]{"edge", "chrome", "firefox", "version", "minefield", "trident"};
    private static final char[] _VERSION_SEPARATORS = new char[]{'\\', '/'};

    public static boolean acceptsGzip(HttpServletRequest httpServletRequest) {
        String acceptEncoding = httpServletRequest.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public static String getAccept(HttpServletRequest httpServletRequest) {
        String accept = "";
        if (httpServletRequest == null) {
            return accept;
        }
        accept = String.valueOf(httpServletRequest.getAttribute("ACCEPT"));
        if (Validator.isNotNull((String)accept)) {
            return accept;
        }
        accept = httpServletRequest.getHeader("ACCEPT");
        accept = accept != null ? StringUtil.toLowerCase((String)accept) : "";
        httpServletRequest.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    public static String getBrowserId(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        if (browserMetadata.isChrome()) {
            return BROWSER_ID_CHROME;
        }
        if (browserMetadata.isEdge()) {
            return BROWSER_ID_EDGE;
        }
        if (browserMetadata.isIe()) {
            return BROWSER_ID_IE;
        }
        if (browserMetadata.isFirefox()) {
            return BROWSER_ID_FIREFOX;
        }
        return BROWSER_ID_OTHER;
    }

    public static BrowserMetadata getBrowserMetadata(HttpServletRequest httpServletRequest) {
        return new BrowserMetadata(BrowserSnifferUtil._getUserAgent(httpServletRequest));
    }

    public static float getMajorVersion(HttpServletRequest httpServletRequest) {
        return GetterUtil.getFloat((String)BrowserSnifferUtil.getVersion(httpServletRequest));
    }

    public static String getRevision(HttpServletRequest httpServletRequest) {
        String revision = (String)httpServletRequest.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = BrowserSnifferUtil.parseVersion(BrowserSnifferUtil._getUserAgent(httpServletRequest), _REVISION_LEADINGS, _REVISION_SEPARATORS);
        httpServletRequest.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    public static String getVersion(HttpServletRequest httpServletRequest) {
        String version = (String)httpServletRequest.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = BrowserSnifferUtil._getUserAgent(httpServletRequest);
        version = BrowserSnifferUtil.parseVersion(userAgent, _VERSION_LEADINGS, _VERSION_SEPARATORS);
        if (version.isEmpty()) {
            version = BrowserSnifferUtil.parseVersion(userAgent, _REVISION_LEADINGS, _REVISION_SEPARATORS);
        }
        httpServletRequest.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    public static boolean isAir(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isAir();
    }

    public static boolean isAndroid(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isAndroid();
    }

    public static boolean isChrome(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isChrome();
    }

    public static boolean isEdge(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isEdge();
    }

    public static boolean isFirefox(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isFirefox();
    }

    public static boolean isGecko(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isGecko();
    }

    public static boolean isIe(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIe();
    }

    public static boolean isIeOnWin32(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIeOnWin32();
    }

    public static boolean isIeOnWin64(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIeOnWin64();
    }

    public static boolean isIphone(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIphone();
    }

    public static boolean isLinux(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isLinux();
    }

    public static boolean isMac(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMac();
    }

    public static boolean isMobile(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMobile();
    }

    public static boolean isMozilla(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMozilla();
    }

    public static boolean isOpera(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isOpera();
    }

    public static boolean isRtf(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isRtf(BrowserSnifferUtil.getVersion(httpServletRequest));
    }

    public static boolean isSafari(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isSafari();
    }

    public static boolean isSun(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isSun();
    }

    public static boolean isWebKit(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isWebKit();
    }

    public static boolean isWindows(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = BrowserSnifferUtil.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isWindows();
    }

    public static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        for (String leading : leadings) {
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                for (char separator : separators) {
                    if (c1 != separator) {
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    for (int i = majorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        majorEnd = i;
                        break;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (majorEnd >= userAgent.length() || userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    for (int i = minorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        minorEnd = i;
                        break;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    String version = StringBundler.concat((String[])new String[]{major, ".", minor});
                    if (leading.equals("trident")) {
                        if (version.equals("7.0")) {
                            version = "11.0";
                        } else if (version.equals("6.0")) {
                            version = "10.0";
                        } else if (version.equals("5.0")) {
                            version = "9.0";
                        } else if (version.equals("4.0")) {
                            version = "8.0";
                        }
                    }
                    return version;
                }
            }
        }
        return "";
    }

    private static String _getUserAgent(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return "";
        }
        Object userAgentObject = httpServletRequest.getAttribute("User-Agent");
        if (userAgentObject != null) {
            return userAgentObject.toString();
        }
        String userAgent = httpServletRequest.getHeader("User-Agent");
        userAgent = userAgent != null ? StringUtil.toLowerCase((String)userAgent) : "";
        httpServletRequest.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }
}

