/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class BaseAuthFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(BaseAuthFilter.class);
    private boolean _basicAuthEnabled;
    private boolean _digestAuthEnabled;
    private Set<String> _hostsAllowed;
    private boolean _httpsRequired;
    private boolean _usePermissionChecker;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("basic_auth"));
        this._digestAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("digest_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowed = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowed = StringUtil.split((String)filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowed = PropsUtil.getArray(propertyPrefix + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get(propertyPrefix + "https.required"));
        }
        this._hostsAllowed = hostsAllowed.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(hostsAllowed));
        this._usePermissionChecker = GetterUtil.getBoolean((String)filterConfig.getInitParameter("use_permission_checker"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpServletRequest basicAuth(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        User user1 = (User)httpSession.getAttribute("USER");
        if (user1 == null) {
            long userId = 0L;
            try {
                userId = HttpAuthManagerUtil.getBasicUserId(httpServletRequest);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            if (userId > 0L) {
                return this.setCredentials(httpServletRequest, httpSession, UserLocalServiceUtil.getUser((long)userId), "BASIC");
            }
            HttpAuthManagerUtil.generateChallenge(httpServletRequest, httpServletResponse, new HttpAuthorizationHeader("Basic"));
            return null;
        }
        User user2 = UserLocalServiceUtil.getUser((long)user1.getUserId());
        if (!user2.isActive()) {
            httpSession.invalidate();
            HttpAuthManagerUtil.generateChallenge(httpServletRequest, httpServletResponse, new HttpAuthorizationHeader("Basic"));
            return null;
        }
        httpServletRequest = new ProtectedServletRequest(httpServletRequest, String.valueOf(user1.getUserId()), "BASIC");
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest));
        return httpServletRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpServletRequest digestAuth(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        User user1 = (User)httpSession.getAttribute("USER");
        if (user1 == null) {
            long userId = 0L;
            try {
                userId = HttpAuthManagerUtil.getDigestUserId(httpServletRequest);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            if (userId > 0L) {
                return this.setCredentials(httpServletRequest, httpSession, UserLocalServiceUtil.getUser((long)userId), "DIGEST");
            }
            HttpAuthManagerUtil.generateChallenge(httpServletRequest, httpServletResponse, new HttpAuthorizationHeader("Digest"));
            return null;
        }
        User user2 = UserLocalServiceUtil.getUser((long)user1.getUserId());
        if (!user2.isActive()) {
            httpSession.invalidate();
            HttpAuthManagerUtil.generateChallenge(httpServletRequest, httpServletResponse, new HttpAuthorizationHeader("Digest"));
            return null;
        }
        httpServletRequest = new ProtectedServletRequest(httpServletRequest, String.valueOf(user1.getUserId()), "DIGEST");
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest));
        return httpServletRequest;
    }

    protected void initThreadLocals(User user) throws Exception {
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        PrincipalThreadLocal.setName((long)user.getUserId());
        if (!this._usePermissionChecker) {
            return;
        }
        PermissionThreadLocal.getPermissionChecker((User)user, (boolean)true);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)httpServletRequest, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + httpServletRequest.getRemoteAddr()));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + httpServletRequest.getRemoteAddr()));
            }
            httpServletResponse.sendError(403, "Access denied for " + httpServletRequest.getRemoteAddr());
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        if (this._httpsRequired && !PortalUtil.isSecure((HttpServletRequest)httpServletRequest)) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBundler sb = new StringBundler(5);
            sb.append(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest, (boolean)true));
            sb.append(PortalUtil.getPathContext((HttpServletRequest)httpServletRequest));
            sb.append(httpServletRequest.getRequestURI());
            if (Validator.isNotNull((String)httpServletRequest.getQueryString())) {
                sb.append("?");
                sb.append(httpServletRequest.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + sb.toString()));
            }
            httpServletResponse.sendRedirect(sb.toString());
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not securing " + HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest)));
            }
            User user = null;
            try {
                user = PortalUtil.initUser((HttpServletRequest)httpServletRequest);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchUserException);
                }
                httpServletResponse.sendRedirect(HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest));
                return;
            }
            this.initThreadLocals(user);
            if (!user.isGuestUser()) {
                String authType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"authType");
                if (authType == null) {
                    Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
                    authType = company.getAuthType();
                }
                httpServletRequest = this.setCredentials(httpServletRequest, httpServletRequest.getSession(), user, authType);
            } else if (this._digestAuthEnabled) {
                httpServletRequest = this.digestAuth(httpServletRequest, httpServletResponse);
            } else if (this._basicAuthEnabled) {
                httpServletRequest = this.basicAuth(httpServletRequest, httpServletResponse);
            }
            if (httpServletRequest != null) {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                this.processFilter(clazz.getName(), httpServletRequest, httpServletResponse, filterChain);
            }
        }
    }

    protected HttpServletRequest setCredentials(HttpServletRequest httpServletRequest, HttpSession httpSession, User user, String authType) throws Exception {
        httpServletRequest = new ProtectedServletRequest(httpServletRequest, String.valueOf(user.getUserId()), authType);
        PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest));
        return httpServletRequest;
    }

    protected void setUsePermissionChecker(boolean usePermissionChecker) {
        this._usePermissionChecker = usePermissionChecker;
    }
}

