/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.dao.orm.hibernate.VerifySessionFactoryWrapper;
import com.liferay.portal.kernel.aop.SkipAop;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.transaction.TransactionInvoker;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.spring.aop.AopCacheManager;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.spring.aop.BaseServiceBeanAutoProxyCreator;
import com.liferay.portal.spring.aop.BeanMatcher;
import com.liferay.portal.spring.bean.BeanReferenceAnnotationBeanPostProcessor;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.spring.hibernate.PortletTransactionManager;
import com.liferay.portal.spring.transaction.DefaultTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionInvokerImpl;
import com.liferay.portal.spring.transaction.TransactionManagerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class AopConfigurableApplicationContextConfigurator
implements ConfigurableApplicationContextConfigurator {
    @Override
    public void configure(ConfigurableApplicationContext configurableApplicationContext) {
        configurableApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new AopBeanFactoryPostProcessor(configurableApplicationContext.getClassLoader()));
    }

    private static class ServiceBeanAutoProxyCreator
    extends BaseServiceBeanAutoProxyCreator {
        private final List<AopInvocationHandler> _aopInvocationHandlers = new ArrayList<AopInvocationHandler>();
        private final TransactionExecutor _transactionExecutor;

        public void destroy() {
            for (AopInvocationHandler aopInvocationHandler : this._aopInvocationHandlers) {
                AopCacheManager.destroy(aopInvocationHandler);
            }
        }

        @Override
        protected AopInvocationHandler createAopInvocationHandler(Object bean) {
            AopInvocationHandler aopInvocationHandler = AopCacheManager.create(bean, this._transactionExecutor);
            this._aopInvocationHandlers.add(aopInvocationHandler);
            return aopInvocationHandler;
        }

        private ServiceBeanAutoProxyCreator(ClassLoader classLoader, TransactionExecutor transactionExecutor) {
            super(new ServiceBeanMatcher(), classLoader);
            this._transactionExecutor = transactionExecutor;
        }
    }

    private static class BasePersistenceInjectionBeanPostProcessor
    implements BeanPostProcessor {
        private final DataSource _dataSource;
        private final com.liferay.portal.kernel.dao.orm.SessionFactory _sessionFactory;

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            if (bean instanceof BasePersistenceImpl) {
                BasePersistenceImpl basePersistenceImpl = (BasePersistenceImpl)bean;
                basePersistenceImpl.setDataSource(this._dataSource);
                basePersistenceImpl.setSessionFactory(this._sessionFactory);
            }
            return bean;
        }

        private BasePersistenceInjectionBeanPostProcessor(DataSource dataSource, com.liferay.portal.kernel.dao.orm.SessionFactory sessionFactory) {
            this._dataSource = dataSource;
            this._sessionFactory = sessionFactory;
        }
    }

    private static class AopBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor {
        private final ClassLoader _classLoader;

        public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
            if (configurableListableBeanFactory.getBeanDefinitionCount() == 0) {
                return;
            }
            configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanReferenceAnnotationBeanPostProcessor((BeanFactory)configurableListableBeanFactory));
            DefaultSingletonBeanRegistry defaultSingletonBeanRegistry = (DefaultSingletonBeanRegistry)configurableListableBeanFactory;
            DefaultTransactionExecutor defaultTransactionExecutor = new DefaultTransactionExecutor(this._getPlatformTransactionManager(configurableListableBeanFactory));
            configurableListableBeanFactory.registerSingleton("transactionExecutor", (Object)defaultTransactionExecutor);
            if (PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)this._classLoader)) {
                TransactionInvokerImpl transactionInvokerImpl = new TransactionInvokerImpl();
                transactionInvokerImpl.setTransactionExecutor(defaultTransactionExecutor);
                TransactionInvokerUtil transactionInvokerUtil = new TransactionInvokerUtil();
                transactionInvokerUtil.setTransactionInvoker((TransactionInvoker)transactionInvokerImpl);
            }
            ServiceBeanAutoProxyCreator serviceBeanAutoProxyCreator = new ServiceBeanAutoProxyCreator(this._classLoader, defaultTransactionExecutor);
            defaultSingletonBeanRegistry.registerDisposableBean("serviceBeanAutoProxyCreatorDestroyer", serviceBeanAutoProxyCreator::destroy);
            configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)serviceBeanAutoProxyCreator);
        }

        private AopBeanFactoryPostProcessor(ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        private PlatformTransactionManager _getPlatformTransactionManager(ConfigurableListableBeanFactory configurableListableBeanFactory) {
            DataSource liferayDataSource = (DataSource)configurableListableBeanFactory.getBean("liferayDataSource", DataSource.class);
            SessionFactoryImplementor liferayHibernateSessionFactory = null;
            DefaultSingletonBeanRegistry defaultSingletonBeanRegistry = (DefaultSingletonBeanRegistry)configurableListableBeanFactory;
            if (PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)this._classLoader)) {
                liferayHibernateSessionFactory = (SessionFactoryImplementor)configurableListableBeanFactory.getBean("liferayHibernateSessionFactory", SessionFactoryImplementor.class);
            } else {
                PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration(this._classLoader, liferayDataSource);
                try {
                    portletHibernateConfiguration.afterPropertiesSet();
                    liferayHibernateSessionFactory = (SessionFactoryImplementor)portletHibernateConfiguration.getObject();
                }
                catch (Exception exception) {
                    return (PlatformTransactionManager)ReflectionUtil.throwException((Throwable)exception);
                }
                defaultSingletonBeanRegistry.registerDisposableBean("liferayHibernateSessionFactoryDestroyer", () -> ((SessionFactoryImplementor)liferayHibernateSessionFactory).close());
            }
            SessionFactoryImpl sessionFactoryImpl = new SessionFactoryImpl();
            sessionFactoryImpl.setSessionFactoryClassLoader(this._classLoader);
            sessionFactoryImpl.setSessionFactoryImplementor(liferayHibernateSessionFactory);
            defaultSingletonBeanRegistry.registerDisposableBean("liferaySessionFactoryDestroyer", sessionFactoryImpl::destroy);
            com.liferay.portal.kernel.dao.orm.SessionFactory sessionFactory = VerifySessionFactoryWrapper.createVerifySessionFactoryWrapper(sessionFactoryImpl);
            configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new BasePersistenceInjectionBeanPostProcessor(liferayDataSource, sessionFactory));
            if (PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)this._classLoader)) {
                return (PlatformTransactionManager)configurableListableBeanFactory.getBean("liferayTransactionManager", PlatformTransactionManager.class);
            }
            if (InfrastructureUtil.getDataSource() == liferayDataSource) {
                return new PortletTransactionManager((HibernateTransactionManager)InfrastructureUtil.getTransactionManager(), liferayHibernateSessionFactory);
            }
            return TransactionManagerFactory.createTransactionManager(liferayDataSource, (SessionFactory)liferayHibernateSessionFactory);
        }
    }

    public static class ServiceBeanMatcher
    implements BeanMatcher {
        private static final String _SERVICE_SUFFIX = "Service";

        @Override
        public boolean match(Class<?> beanClass, String beanName) {
            return beanName.endsWith(_SERVICE_SUFFIX) && beanClass.getAnnotation(SkipAop.class) == null;
        }
    }
}

