/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.bean;

import com.liferay.portal.spring.aop.BaseServiceBeanAutoProxyCreator;
import com.liferay.portal.util.PropsValues;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class LiferayBeanFactory
extends DefaultListableBeanFactory {
    private boolean _postProcessPropertyValues;

    public LiferayBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        super.addBeanPostProcessor(beanPostProcessor);
        if (beanPostProcessor instanceof InstantiationAwareBeanPostProcessor && !(beanPostProcessor instanceof BaseServiceBeanAutoProxyCreator)) {
            this._postProcessPropertyValues = true;
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, RootBeanDefinition rootBeanDefinition) throws Throwable {
        if (!PropsValues.SPRING_BEANFACTORY_STRICT_LIFECYCLE_ENABLED) {
            super.invokeCustomInitMethod(beanName, bean, rootBeanDefinition);
            return;
        }
        Method initMethod = this._getMethod(bean.getClass(), rootBeanDefinition.getInitMethodName());
        if (initMethod != null) {
            try {
                initMethod.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }

    protected void populateBean(String beanName, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper) {
        MutablePropertyValues propertyValues = rootBeanDefinition.getPropertyValues();
        if (beanWrapper == null) {
            if (propertyValues.isEmpty()) {
                return;
            }
            throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), beanName, "Unable to apply property values to null instance");
        }
        if (!this._isContinueWithPropertyPopulation(beanName, rootBeanDefinition, beanWrapper)) {
            return;
        }
        if (rootBeanDefinition.getResolvedAutowireMode() == 1 || rootBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mutablePropertyValues = new MutablePropertyValues((PropertyValues)propertyValues);
            if (rootBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, (AbstractBeanDefinition)rootBeanDefinition, beanWrapper, mutablePropertyValues);
            }
            if (rootBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, (AbstractBeanDefinition)rootBeanDefinition, beanWrapper, mutablePropertyValues);
            }
            propertyValues = mutablePropertyValues;
        }
        boolean hasInstantiationAwareBeanPostProcessors = this.hasInstantiationAwareBeanPostProcessors();
        boolean needsDependencyCheck = true;
        if (rootBeanDefinition.getDependencyCheck() == 0) {
            needsDependencyCheck = false;
        }
        if (hasInstantiationAwareBeanPostProcessors && this._postProcessPropertyValues || needsDependencyCheck) {
            PropertyDescriptor[] propertyDescriptors = this.filterPropertyDescriptorsForDependencyCheck(beanWrapper, true);
            if (hasInstantiationAwareBeanPostProcessors) {
                for (BeanPostProcessor beanPostProcessor : this.getBeanPostProcessors()) {
                    InstantiationAwareBeanPostProcessor instantiationAwareBeanPostProcessor;
                    if (!(beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) || (propertyValues = (instantiationAwareBeanPostProcessor = (InstantiationAwareBeanPostProcessor)beanPostProcessor).postProcessPropertyValues((PropertyValues)propertyValues, propertyDescriptors, beanWrapper.getWrappedInstance(), beanName)) != null) continue;
                    return;
                }
            }
            if (needsDependencyCheck) {
                this.checkDependencies(beanName, (AbstractBeanDefinition)rootBeanDefinition, propertyDescriptors, (PropertyValues)propertyValues);
            }
        }
        this.applyPropertyValues(beanName, (BeanDefinition)rootBeanDefinition, beanWrapper, (PropertyValues)propertyValues);
    }

    protected void registerDisposableBeanIfNecessary(String beanName, Object bean, RootBeanDefinition rootBeanDefinition) {
        if (!PropsValues.SPRING_BEANFACTORY_STRICT_LIFECYCLE_ENABLED) {
            super.registerDisposableBeanIfNecessary(beanName, bean, rootBeanDefinition);
            return;
        }
        String destroyMethodName = rootBeanDefinition.getDestroyMethodName();
        if (destroyMethodName == null) {
            return;
        }
        Method destroyMethod = this._getMethod(bean.getClass(), destroyMethodName);
        if (destroyMethod != null) {
            Method finalDestroyMethod = destroyMethod;
            this.registerDisposableBean(beanName, () -> finalDestroyMethod.invoke(bean, new Object[0]));
        }
    }

    private Method _getMethod(Class<?> clazz, String methodName) {
        while (clazz != null && clazz != Object.class) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private boolean _isContinueWithPropertyPopulation(String beanName, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper) {
        if (!rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            for (BeanPostProcessor beanPostProcessor : this.getBeanPostProcessors()) {
                InstantiationAwareBeanPostProcessor instantiationAwareBeanPostProcessor;
                if (!(beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) || (instantiationAwareBeanPostProcessor = (InstantiationAwareBeanPostProcessor)beanPostProcessor).postProcessAfterInstantiation(beanWrapper.getWrappedInstance(), beanName)) continue;
                return false;
            }
        }
        return true;
    }
}

