/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpgradeOrganization
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.alterColumnType("Organization_", "statusId", "LONG");
        this.upgradeOrganizationLogoId();
        this.upgradeOrganizationSiteHierarchy();
    }

    protected void upgradeOrganizationLogoId() throws SQLException {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select groupId, logoId from LayoutSet where logoId > 0 and privateLayout = ?");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select classPK from Group_ where groupId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("update Organization_ set logoId = ? where organizationId = ?");){
            preparedStatement1.setBoolean(1, false);
            ResultSet resultSet1 = preparedStatement1.executeQuery();
            while (resultSet1.next()) {
                long groupId = resultSet1.getLong("groupId");
                long logoId = resultSet1.getLong("logoId");
                preparedStatement2.setLong(1, groupId);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    long classPK = resultSet2.getLong("classPK");
                    preparedStatement3.setLong(1, logoId);
                    preparedStatement3.setLong(2, classPK);
                    preparedStatement3.executeUpdate();
                }
            }
        }
    }

    protected void upgradeOrganizationSiteHierarchy() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select groupId, organizationId, parentOrganizationId, ", "site, Organization_.treePath as treePath from Group_, ", "Organization_ where classNameId = ", PortalUtil.getClassNameId((String)Organization.class.getName()), " and Group_.classPK = Organization_.organizationId"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Group_ set parentGroupId = ?, treePath = ? where groupId = ?");){
            ArrayList<OrganizationGroup> organizationGroups = new ArrayList<OrganizationGroup>();
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    organizationGroups.add(new OrganizationGroup(resultSet.getLong("groupId"), resultSet.getLong("organizationId"), resultSet.getString("treePath"), resultSet.getLong("parentOrganizationId"), resultSet.getBoolean("site")));
                }
            }
            for (OrganizationGroup organizationGroup : organizationGroups) {
                if (!organizationGroup._site) continue;
                List organizationIds = StringUtil.split((String)organizationGroup._organizationTreePath, (char)'/');
                StringBundler sb = new StringBundler(2 * organizationIds.size() + 1);
                sb.append("/");
                for (String organizationId : organizationIds) {
                    if (organizationId.length() <= 0) continue;
                    sb.append(OrganizationGroup.getGroupId(organizationId));
                    sb.append("/");
                }
                preparedStatement2.setLong(1, OrganizationGroup.getGroupId(organizationGroup._parentOrganizationId));
                preparedStatement2.setString(2, sb.toString());
                preparedStatement2.setLong(3, organizationGroup._groupId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private static class OrganizationGroup {
        private static final Map<String, Long> _groupIds = HashMapBuilder.put((Object)String.valueOf(0), (Object)0L).build();
        private final long _groupId;
        private final long _organizationId;
        private final String _organizationTreePath;
        private final long _parentOrganizationId;
        private final boolean _site;

        public static long getGroupId(long organizationId) {
            return OrganizationGroup.getGroupId(String.valueOf(organizationId));
        }

        public static long getGroupId(String organizationId) {
            return _groupIds.get(organizationId);
        }

        public OrganizationGroup(long groupId, long organizationId, String organizationTreePath, long parentOrganizationId, boolean site) {
            this._groupId = groupId;
            this._organizationId = organizationId;
            this._organizationTreePath = organizationTreePath;
            this._parentOrganizationId = parentOrganizationId;
            this._site = site;
            _groupIds.put(String.valueOf(this._organizationId), this._groupId);
        }
    }
}

