/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeRatings
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeRatingsEntry();
        this.upgradeRatingsStats();
    }

    protected void upgradeRatingsEntry() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select distinct classNameId from RatingsEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                this.upgradeRatingsEntry(resultSet.getLong("classNameId"));
            }
        }
    }

    protected void upgradeRatingsEntry(long classNameId) throws Exception {
        String className = PortalUtil.getClassName((long)classNameId);
        if (ArrayUtil.contains((Object[])PropsValues.RATINGS_UPGRADE_THUMBS_CLASS_NAMES, (Object)className)) {
            this.upgradeRatingsEntryThumbs(classNameId);
        } else {
            int defaultRatingsStarsNormalizationFactor = GetterUtil.getInteger((String)PropsUtil.get("ratings.upgrade.stars.normalization.factor", new Filter("default")), (int)5);
            int ratingsStarsNormalizationFactor = GetterUtil.getInteger((String)PropsUtil.get("ratings.upgrade.stars.normalization.factor", new Filter(className)), (int)defaultRatingsStarsNormalizationFactor);
            this.upgradeRatingsEntryStars(classNameId, ratingsStarsNormalizationFactor);
        }
    }

    protected void upgradeRatingsEntryStars(long classNameId, int normalizationFactor) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update RatingsEntry set score = score / ? where classNameId = ?");){
            preparedStatement.setInt(1, normalizationFactor);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.executeUpdate();
        }
    }

    protected void upgradeRatingsEntryThumbs(long classNameId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update RatingsEntry set score = ? where score = ? and classNameId = ?");){
            preparedStatement.setDouble(1, 0.0);
            preparedStatement.setDouble(2, -1.0);
            preparedStatement.setLong(3, classNameId);
            preparedStatement.executeUpdate();
        }
    }

    protected void upgradeRatingsStats() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String selectSQL = StringBundler.concat((String[])new String[]{"select classNameId, classPK, count(1) as totalEntries, ", "sum(RatingsEntry.score) as totalScore, ", "sum(RatingsEntry.score) / count(1) as averageScore from ", "RatingsEntry group by classNameId, classPK"});
            String updateSQL = "update RatingsStats set totalEntries = ?, totalScore = ?, averageScore = ? where classNameId = ? and classPK = ?";
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(selectSQL);
                 ResultSet resultSet = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)updateSQL);){
                while (resultSet.next()) {
                    preparedStatement2.setInt(1, resultSet.getInt("totalEntries"));
                    preparedStatement2.setDouble(2, resultSet.getDouble("totalScore"));
                    preparedStatement2.setDouble(3, resultSet.getDouble("averageScore"));
                    preparedStatement2.setLong(4, resultSet.getLong("classNameId"));
                    preparedStatement2.setLong(5, resultSet.getLong("classPK"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

