/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.encryptor.EncryptorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.StAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferenceKey;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.Preference;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.portlet.portletconfiguration.util.ConfigurationPortletRequest;
import java.io.Reader;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesFactoryImpl.class);
    private Map<String, Preference> _defaultPreferencesMap;
    private final PortalCache<String, Map<String, Preference>> _preferencesMapPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)PortletPreferencesFactoryImpl.class.getName());

    public static Map<String, Preference> createPreferencesMap(String xml) {
        HashMap<String, Preference> preferencesMap = new HashMap<String, Preference>();
        XMLEventReader xmlEventReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlEventReader = xmlInputFactory.createXMLEventReader((Reader)new UnsyncStringReader(xml));
            while (xmlEventReader.hasNext()) {
                StartElement startElement;
                QName startElementName;
                String elementName;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement() || !(elementName = (startElementName = (startElement = xmlEvent.asStartElement()).getName()).getLocalPart()).equals("preference")) continue;
                Preference preference = PortletPreferencesFactoryImpl.readPreference(xmlEventReader);
                preferencesMap.put(preference.getName(), preference);
            }
        }
        catch (XMLStreamException xmlStreamException) {
            throw new SystemException((Throwable)xmlStreamException);
        }
        finally {
            block12: {
                if (xmlEventReader != null) {
                    try {
                        xmlEventReader.close();
                    }
                    catch (XMLStreamException xmlStreamException) {
                        if (!_log.isDebugEnabled()) break block12;
                        _log.debug((Throwable)xmlStreamException);
                    }
                }
            }
        }
        return preferencesMap;
    }

    public void checkControlPanelPortletPreferences(ThemeDisplay themeDisplay, Portlet portlet) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (!group.isControlPanel()) {
            return;
        }
        String portletId = portlet.getPortletId();
        boolean hasControlPanelAccessPermission = PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId);
        if (!hasControlPanelAccessPermission) {
            return;
        }
        javax.portlet.PortletPreferences portletPreferences = this.getStrictLayoutPortletSetup(layout, portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            this.getLayoutPortletSetup(layout, portletId);
        }
        if (portlet.isInstanceable()) {
            return;
        }
        PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)this.getPortletPreferencesIds(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), layout, portletId, false));
    }

    public javax.portlet.PortletPreferences fromDefaultXML(String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(xml, preferencesMap);
    }

    public PortalPreferencesImpl fromXML(long ownerId, int ownerType, String xml) {
        HashMap<PortalPreferenceKey, String[]> preferences = new HashMap<PortalPreferenceKey, String[]>();
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        for (Preference preference : preferencesMap.values()) {
            String namespace = null;
            String key = preference.getName();
            int index = key.indexOf(35);
            if (index > 0) {
                namespace = key.substring(0, index);
                key = key.substring(index + 1);
            }
            preferences.put(new PortalPreferenceKey(namespace, key), preference.getValues());
        }
        return new PortalPreferencesImpl(ownerId, ownerType, preferences, false);
    }

    public PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    public javax.portlet.PortletPreferences getExistingPortletSetup(Layout layout, String portletId) throws PortalException {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        javax.portlet.PortletPreferences portletPreferences = this.getStrictPortletSetup(layout, portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            throw new PrincipalException();
        }
        return portletPreferences;
    }

    public javax.portlet.PortletPreferences getExistingPortletSetup(PortletRequest portletRequest) throws PortalException {
        String portletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getExistingPortletSetup(themeDisplay.getLayout(), portletResource);
    }

    public javax.portlet.PortletPreferences getLayoutPortletSetup(Layout layout, String portletId) {
        return this.getLayoutPortletSetup(layout, portletId, null);
    }

    public javax.portlet.PortletPreferences getLayoutPortletSetup(Layout layout, String portletId, String defaultPreferences) {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        return this.getLayoutPortletSetup(layout.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletId, defaultPreferences);
    }

    public javax.portlet.PortletPreferences getLayoutPortletSetup(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        return PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
    }

    public PortalPreferences getPortalPreferences(HttpServletRequest httpServletRequest) {
        long userId;
        ThemeDisplay themeDisplay;
        block4: {
            themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            User user = themeDisplay.getRealUser();
            userId = themeDisplay.getUserId();
            String doAsUserId = themeDisplay.getDoAsUserId();
            if (user != null && !user.isGuestUser() && Validator.isNotNull((String)doAsUserId) && !Objects.equals(String.valueOf(userId), doAsUserId)) {
                Company company = themeDisplay.getCompany();
                try {
                    userId = GetterUtil.getLong((String)EncryptorUtil.decrypt((Key)company.getKeyObj(), (String)doAsUserId), (long)userId);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to decrypt user ID from " + doAsUserId), (Throwable)exception);
                    }
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Unable to decrypt user ID from " + doAsUserId));
                }
            }
        }
        return this.getPortalPreferences(httpServletRequest.getSession(), userId, themeDisplay.isSignedIn());
    }

    public PortalPreferences getPortalPreferences(HttpSession httpSession, long userId, boolean signedIn) {
        PortalPreferencesImpl portalPreferences = null;
        PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences((long)userId, (int)4);
        if (signedIn) {
            portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
        } else {
            if (httpSession != null) {
                portalPreferences = (PortalPreferences)httpSession.getAttribute("PORTAL_PREFERENCES");
            }
            if (portalPreferences == null) {
                portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
                if (httpSession != null) {
                    httpSession.setAttribute("PORTAL_PREFERENCES", (Object)portalPreferences);
                }
            }
        }
        portalPreferences.setSignedIn(signedIn);
        portalPreferences.setUserId(userId);
        return portalPreferences;
    }

    public PortalPreferences getPortalPreferences(long userId, boolean signedIn) {
        return this.getPortalPreferences(null, userId, signedIn);
    }

    public PortalPreferences getPortalPreferences(PortletRequest portletRequest) {
        return this.getPortalPreferences(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest));
    }

    public javax.portlet.PortletPreferences getPortletPreferences(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        return PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)this.getPortletPreferencesIds(httpServletRequest, portletId));
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest httpServletRequest, Layout layout, String portletId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        boolean modeEditGuest = false;
        String portletMode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_mode");
        if (portletMode.equals(LiferayPortletMode.EDIT_GUEST.toString()) || layoutTypePortlet != null && layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            modeEditGuest = true;
        }
        return this._getPortletPreferencesIds(themeDisplay, themeDisplay.getSiteGroupId(), PortalUtil.getUserId((HttpServletRequest)httpServletRequest), layout, portletId, modeEditGuest);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        return this.getPortletPreferencesIds(httpServletRequest, layout, portletId);
    }

    public PortletPreferencesIds getPortletPreferencesIds(long siteGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException {
        return this._getPortletPreferencesIds(null, siteGroupId, userId, layout, portletId, modeEditGuest);
    }

    public PortletPreferencesIds getPortletPreferencesIds(long companyId, long siteGroupId, long layoutGroupId, long plid, String portletId) throws IllegalArgumentException {
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet.isPreferencesCompanyWide() || portlet.isPreferencesOwnedByGroup() && !portlet.isPreferencesUniquePerLayout()) {
            portletId = PortletIdCodec.decodePortletName((String)portletId);
        }
        long ownerId = 0L;
        int ownerType = 0;
        Group group = GroupLocalServiceUtil.fetchGroup((long)siteGroupId);
        if (group != null && group.isLayout()) {
            plid = group.getClassPK();
        }
        if (PortletIdCodec.hasUserId((String)originalPortletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)originalPortletId);
            ownerType = 4;
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerType = 3;
        } else if (portlet.isPreferencesOwnedByGroup()) {
            plid = 0L;
            ownerId = siteGroupId > 0L ? siteGroupId : layoutGroupId;
            ownerType = 2;
        } else if (portlet.isPreferencesCompanyWide()) {
            plid = 0L;
            ownerId = companyId;
            ownerType = 1;
        }
        if (ownerType == 0) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Portlet ", originalPortletId, " has owner type 0 because of wrong properties or wrong ", "data handler settings"}));
        }
        if (ownerId == 0L && plid == 0L) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Portlet ", originalPortletId, " has owner ID of 0 and PLID of 0 because of wrong ", "properties or wrong data handler settings"}));
        }
        return new PortletPreferencesIds(companyId, ownerId, ownerType, plid, portletId);
    }

    public PortletPreferencesIds getPortletPreferencesIds(long companyId, long siteGroupId, long plid, String portletId, String settingsScope) {
        int ownerType = 0;
        long ownerId = 0L;
        if (settingsScope.equals("company")) {
            ownerId = companyId;
            ownerType = 1;
            plid = 0L;
        } else if (settingsScope.equals("group")) {
            ownerId = siteGroupId;
            ownerType = 2;
            plid = 0L;
        } else if (settingsScope.equals("portletInstance")) {
            ownerId = 0L;
            ownerType = 3;
            if (PortletIdCodec.hasUserId((String)portletId)) {
                ownerId = PortletIdCodec.decodeUserId((String)portletId);
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(companyId, ownerId, ownerType, plid, portletId);
    }

    public javax.portlet.PortletPreferences getPortletSetup(HttpServletRequest httpServletRequest, String portletId) {
        return this.getPortletSetup(httpServletRequest, portletId, null);
    }

    public javax.portlet.PortletPreferences getPortletSetup(HttpServletRequest httpServletRequest, String portletId, String defaultPreferences) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getPortletSetup(themeDisplay.getSiteGroupId(), themeDisplay.getLayout(), portletId, defaultPreferences);
    }

    public javax.portlet.PortletPreferences getPortletSetup(Layout layout, String portletId, String defaultPreferences) {
        return this.getPortletSetup(0L, layout, portletId, defaultPreferences);
    }

    public javax.portlet.PortletPreferences getPortletSetup(long siteGroupId, Layout layout, String portletId, String defaultPreferences) {
        return this.getPortletSetup(layout.getCompanyId(), siteGroupId, layout.getGroupId(), layout.getPlid(), portletId, defaultPreferences, false);
    }

    public javax.portlet.PortletPreferences getPortletSetup(PortletRequest portletRequest) {
        return this.getPortletSetup(portletRequest, PortalUtil.getPortletId((PortletRequest)portletRequest));
    }

    public javax.portlet.PortletPreferences getPortletSetup(PortletRequest portletRequest, String portletId) {
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        return this.getPortletSetup(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), portletId);
    }

    public Map<Long, javax.portlet.PortletPreferences> getPortletSetupMap(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        HashMap<Long, javax.portlet.PortletPreferences> portletSetupMap = new HashMap<Long, javax.portlet.PortletPreferences>();
        List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)companyId, (long)groupId, (long)ownerId, (int)ownerType, (String)portletId, (boolean)privateLayout);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            portletSetupMap.put(portletPreferences.getPlid(), PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)portletPreferences.getPlid(), (String)portletId));
        }
        return portletSetupMap;
    }

    public javax.portlet.PortletPreferences getPreferences(HttpServletRequest httpServletRequest) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (portletRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        return PortalUtil.getPreferencesValidator((Portlet)portlet);
    }

    public javax.portlet.PortletPreferences getStrictLayoutPortletSetup(Layout layout, String portletId) {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public javax.portlet.PortletPreferences getStrictPortletSetup(Layout layout, String portletId) {
        return this.getPortletSetup(layout.getCompanyId(), 0L, layout.getGroupId(), layout.getPlid(), portletId, "", true);
    }

    public javax.portlet.PortletPreferences getStrictPortletSetup(long companyId, long groupId, String portletId) {
        return this.getPortletSetup(companyId, 0L, groupId, 0L, portletId, "", true);
    }

    public StrictPortletPreferencesImpl strictFromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new StrictPortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    public String toXML(PortalPreferences portalPreferences) {
        PortalPreferencesImpl portalPreferencesImpl = null;
        if (portalPreferences instanceof PortalPreferencesWrapper) {
            PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)portalPreferences;
            portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
        } else {
            portalPreferencesImpl = (PortalPreferencesImpl)portalPreferences;
        }
        return portalPreferencesImpl.toXML();
    }

    public String toXML(javax.portlet.PortletPreferences portletPreferences) {
        PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences instanceof PortletPreferencesWrapper) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
            portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        } else {
            portletPreferencesImpl = (PortletPreferencesImpl)portletPreferences;
        }
        return portletPreferencesImpl.toXML();
    }

    protected static Preference readPreference(XMLEventReader xmlEventReader) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        boolean readOnly = false;
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            QName endElementName;
            String elementName;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String value;
                StartElement startElement = xmlEvent.asStartElement();
                QName startElementName = startElement.getName();
                elementName = startElementName.getLocalPart();
                if (elementName.equals("name")) {
                    name = StAXReaderUtil.read((XMLEventReader)xmlEventReader);
                    continue;
                }
                if (elementName.equals("value")) {
                    value = StAXReaderUtil.read((XMLEventReader)xmlEventReader);
                    values.add(value);
                    continue;
                }
                if (!elementName.equals("read-only")) continue;
                value = StAXReaderUtil.read((XMLEventReader)xmlEventReader);
                readOnly = GetterUtil.getBoolean((String)value);
                continue;
            }
            if (!xmlEvent.isEndElement() || !(elementName = (endElementName = (endElement = xmlEvent.asEndElement()).getName()).getLocalPart()).equals("preference")) continue;
            break;
        }
        return new Preference(name, values.toArray(new String[0]), readOnly);
    }

    protected javax.portlet.PortletPreferences getPortletSetup(long companyId, long siteGroupId, long layoutGroupId, long plid, String portletId, String defaultPreferences, boolean strictMode) {
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(companyId, siteGroupId, layoutGroupId, plid, portletId);
        if (strictMode) {
            return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)portletPreferencesIds.getCompanyId(), (long)portletPreferencesIds.getOwnerId(), (int)portletPreferencesIds.getOwnerType(), (long)portletPreferencesIds.getPlid(), (String)portletPreferencesIds.getPortletId());
        }
        return PortletPreferencesLocalServiceUtil.getPreferences((long)portletPreferencesIds.getCompanyId(), (long)portletPreferencesIds.getOwnerId(), (int)portletPreferencesIds.getOwnerType(), (long)portletPreferencesIds.getPlid(), (String)portletPreferencesIds.getPortletId(), (String)defaultPreferences);
    }

    protected Map<String, Preference> toPreferencesMap(String xml) {
        if (Objects.equals(xml, "<portlet-preferences />")) {
            if (this._defaultPreferencesMap == null) {
                this._defaultPreferencesMap = PortletPreferencesFactoryImpl.createPreferencesMap("<portlet-preferences />");
            }
            return this._defaultPreferencesMap;
        }
        if (Validator.isNull((String)xml)) {
            return Collections.emptyMap();
        }
        String cacheKey = this._encodeCacheKey(xml);
        Map<String, Preference> preferencesMap = (Map<String, Preference>)this._preferencesMapPortalCache.get((Serializable)((Object)cacheKey));
        if (preferencesMap != null) {
            return preferencesMap;
        }
        preferencesMap = PortletPreferencesFactoryImpl.createPreferencesMap(xml);
        this._preferencesMapPortalCache.put((Serializable)((Object)cacheKey), preferencesMap);
        return preferencesMap;
    }

    private String _encodeCacheKey(String xml) {
        if (xml.length() <= PropsValues.PORTLET_PREFERENCES_CACHE_KEY_THRESHOLD_SIZE) {
            return xml;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)PortletPreferencesFactoryImpl.class.getName());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cache key generator " + cacheKeyGenerator.getClass()));
        }
        return String.valueOf(cacheKeyGenerator.getCacheKey(xml));
    }

    private PortletPreferencesIds _getPortletPreferencesIds(ThemeDisplay themeDisplay, long siteGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException {
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        if (modeEditGuest) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            if (layout.isPrivateLayout() || !hasUpdateLayoutPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), new String[]{"UPDATE"});
            }
        }
        long ownerId = 0L;
        int ownerType = 0;
        long plid = 0L;
        if (PortletIdCodec.hasUserId((String)originalPortletId) && PortletIdCodec.decodeUserId((String)originalPortletId) == userId) {
            ownerId = userId;
            ownerType = 4;
            plid = layout.getPlid();
        } else if (portlet.isPreferencesCompanyWide()) {
            ownerId = layout.getCompanyId();
            ownerType = 1;
            plid = 0L;
            portletId = PortletIdCodec.decodePortletName((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerId = 0L;
            long masterLayoutPlid = layout.getMasterLayoutPlid();
            long portletPreferencesCount = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)3, (long)masterLayoutPlid, (String)portletId);
            plid = masterLayoutPlid > 0L && portletPreferencesCount > 0L ? masterLayoutPlid : layout.getPlid();
            if (themeDisplay != null) {
                if (themeDisplay.isPortletEmbedded(layout.getGroupId(), layout, portletId)) {
                    ownerId = layout.getGroupId();
                    plid = 0L;
                }
            } else if (layout.isPortletEmbedded(portletId, layout.getGroupId())) {
                ownerId = layout.getGroupId();
                plid = 0L;
            }
            ownerType = 3;
            if (!portlet.isPreferencesOwnedByGroup()) {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getGuestUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        } else {
            plid = 0L;
            if (portlet.isPreferencesOwnedByGroup()) {
                ownerId = siteGroupId;
                ownerType = 2;
                portletId = PortletIdCodec.decodePortletName((String)portletId);
            } else {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getGuestUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(layout.getCompanyId(), ownerId, ownerType, plid, portletId);
    }
}

