/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class DLFileVersionLocalServiceImpl
extends DLFileVersionLocalServiceBaseImpl {
    @BeanReference(type=DLFileEntryLocalService.class)
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;

    public DLFileVersion fetchLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) {
        List dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        if (dlFileVersions.isEmpty()) {
            return null;
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, DLFileVersionVersionComparator.getInstance((boolean)false));
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        String version = dlFileVersion.getVersion();
        if (excludeWorkingCopy && version.equals("PWC")) {
            return (DLFileVersion)dlFileVersions.get(1);
        }
        return dlFileVersion;
    }

    public DLFileVersion fetchLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy, int status) {
        if (status == -1) {
            return this.fetchLatestFileVersion(fileEntryId, excludeWorkingCopy);
        }
        return this.dlFileVersionPersistence.fetchByF_S_Last(fileEntryId, status, (OrderByComparator)DLFileVersionVersionComparator.getInstance((boolean)false));
    }

    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    public DLFileVersion getFileVersion(long fileEntryId, String version) throws PortalException {
        return this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
    }

    public DLFileVersion getFileVersionByUuidAndGroupId(String uuid, long groupId) {
        return this.dlFileVersionPersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) {
        List dlFileVersions = null;
        dlFileVersions = status == -1 ? this.dlFileVersionPersistence.findByFileEntryId(fileEntryId) : this.dlFileVersionPersistence.findByF_S(fileEntryId, status);
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, DLFileVersionVersionComparator.getInstance((boolean)false));
        return dlFileVersions;
    }

    public List<DLFileVersion> getFileVersions(long fileEntryId, int status, int start, int end) {
        if (status == -1) {
            return this.dlFileVersionPersistence.findByFileEntryId(fileEntryId, start, end, (OrderByComparator)DLFileVersionVersionComparator.getInstance((boolean)false));
        }
        return this.dlFileVersionPersistence.findByF_S(fileEntryId, status, start, end, (OrderByComparator)DLFileVersionVersionComparator.getInstance((boolean)false));
    }

    public int getFileVersionsCount(long fileEntryId, int status) {
        if (status == -1) {
            return this.dlFileVersionPersistence.countByFileEntryId(fileEntryId);
        }
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    public int getFileVersionsCount(long companyId, String storeUUID) {
        return this.dlFileVersionPersistence.countByC_SU(companyId, storeUUID);
    }

    public DLFileVersion getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws PortalException {
        DLFileVersion dlFileVersion = this.fetchLatestFileVersion(fileEntryId, excludeWorkingCopy);
        if (dlFileVersion == null) {
            throw new NoSuchFileVersionException("No file versions found for fileEntryId " + fileEntryId);
        }
        return dlFileVersion;
    }

    public DLFileVersion getLatestFileVersion(long userId, long fileEntryId) throws PortalException {
        boolean excludeWorkingCopy = true;
        if (this._dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId)) {
            excludeWorkingCopy = !this._dlFileEntryLocalService.hasFileEntryLock(userId, fileEntryId);
        }
        return this.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
    }

    public void rebuildTree(long companyId) throws PortalException {
        this._dlFolderLocalService.rebuildTree(companyId);
    }

    public void setTreePaths(long folderId, String treePath) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            DLFolder dlFolder;
            if (folderId != 0L && (dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId)) != null) {
                Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
                dynamicQuery.add(groupIdProperty.eq((Object)dlFolder.getGroupId()));
            }
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            dlFileVersion.setTreePath(treePath);
            this.updateDLFileVersion((DLFileVersion)dlFileVersion);
        });
        actionableDynamicQuery.performActions();
    }
}

