/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLTrashServiceBaseImpl;

public class DLTrashServiceImpl
extends DLTrashServiceBaseImpl {
    public FileEntry moveFileEntryFromTrash(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
        Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "UPDATE");
        Folder destinationFolder = null;
        if (newFolderId != 0L) {
            destinationFolder = repository.getFolder(newFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileEntryFromTrash(this.getUserId(), fileEntry, destinationFolder, serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long fileEntryId) throws PortalException {
        ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
        Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileEntryToTrash(this.getUserId(), fileEntry);
    }

    public FileShortcut moveFileShortcutFromTrash(long fileShortcutId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileShortcut, "UPDATE");
        Folder destinationFolder = null;
        if (newFolderId != 0L) {
            destinationFolder = repository.getFolder(newFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileShortcutFromTrash(this.getUserId(), fileShortcut, destinationFolder, serviceContext);
    }

    public FileShortcut moveFileShortcutToTrash(long fileShortcutId) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileShortcut, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFileShortcutToTrash(this.getUserId(), fileShortcut);
    }

    public Folder moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermission folderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName());
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        Folder folder = repository.getFolder(folderId);
        folderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "UPDATE");
        Folder destinationFolder = null;
        if (parentFolderId != 0L) {
            destinationFolder = repository.getFolder(parentFolderId);
        }
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFolderFromTrash(this.getUserId(), folder, destinationFolder, serviceContext);
    }

    public Folder moveFolderToTrash(long folderId) throws PortalException {
        ModelResourcePermission folderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName());
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        Folder folder = repository.getFolder(folderId);
        folderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        return trashCapability.moveFolderToTrash(this.getUserId(), folder);
    }

    public void restoreFileEntryFromTrash(long fileEntryId) throws PortalException {
        ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
        Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        fileEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileEntry, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFileEntryFromTrash(this.getUserId(), fileEntry);
    }

    public void restoreFileShortcutFromTrash(long fileShortcutId) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        FileShortcut fileShortcut = repository.getFileShortcut(fileShortcutId);
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)fileShortcut, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFileShortcutFromTrash(this.getUserId(), fileShortcut);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException {
        ModelResourcePermission folderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName());
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        Folder folder = repository.getFolder(folderId);
        folderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)folder, "DELETE");
        TrashCapability trashCapability = (TrashCapability)repository.getCapability(TrashCapability.class);
        trashCapability.restoreFolderFromTrash(this.getUserId(), folder);
    }
}

