/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdateLanguageAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(UpdateLanguageAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (LanguageUtil.isAvailableLocale((long)themeDisplay.getSiteGroupId(), (Locale)locale)) {
            boolean persistState = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"persistState", (boolean)true);
            if (themeDisplay.isSignedIn() && persistState) {
                UserServiceUtil.updateLanguageId((long)themeDisplay.getUserId(), (String)languageId);
            }
            HttpSession httpSession = httpServletRequest.getSession();
            httpSession.setAttribute("LOCALE", (Object)locale);
            LanguageUtil.updateCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale);
        }
        try {
            httpServletResponse.sendRedirect(this.getRedirect(httpServletRequest, themeDisplay, locale));
        }
        catch (NoSuchLayoutException | IllegalArgumentException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            httpServletResponse.sendError(400, httpServletRequest.getRequestURI());
        }
        return null;
    }

    public String getRedirect(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect"));
        if (Validator.isNull((String)redirect)) {
            throw new IllegalArgumentException();
        }
        String contextPath = httpServletRequest.getContextPath();
        if (Validator.isNotNull((String)contextPath) && !contextPath.equals("/")) {
            redirect = redirect.substring(contextPath.length());
        }
        String layoutURL = redirect;
        String friendlyURLSeparatorPart = "";
        String queryString = "";
        int questionIndex = redirect.indexOf("?");
        if (questionIndex != -1) {
            queryString = redirect.substring(questionIndex);
            layoutURL = redirect.substring(0, questionIndex);
        }
        Object friendlyURLSeparator = "";
        int friendlyURLSeparatorIndex = -1;
        for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if ("/~".equals(urlSeparator) || (friendlyURLSeparatorIndex = layoutURL.indexOf(urlSeparator)) == -1) continue;
            friendlyURLSeparator = urlSeparator;
            break;
        }
        Layout layout = themeDisplay.getLayout();
        if (friendlyURLSeparatorIndex != -1) {
            block24: {
                friendlyURLSeparatorPart = layoutURL.substring(friendlyURLSeparatorIndex);
                try {
                    LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = PortalUtil.getLayoutFriendlyURLSeparatorComposite((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)friendlyURLSeparatorPart, (Map)httpServletRequest.getParameterMap(), (Map)HashMapBuilder.put((Object)"request", (Object)httpServletRequest).build());
                    friendlyURLSeparatorPart = layoutFriendlyURLSeparatorComposite.getFriendlyURL();
                }
                catch (NoSuchLayoutException noSuchLayoutException) {
                    if ("/-/".equals(friendlyURLSeparator)) break block24;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)noSuchLayoutException);
                    }
                    throw noSuchLayoutException;
                }
            }
            layoutURL = layoutURL.substring(0, friendlyURLSeparatorIndex);
        }
        String mappingPart = "";
        List friendlyURLMappers = PortletLocalServiceUtil.getFriendlyURLMappers();
        for (FriendlyURLMapper friendlyURLMapper : friendlyURLMappers) {
            int mappingIndex;
            if (friendlyURLMapper.isCheckMappingWithPrefix() || (mappingIndex = layoutURL.indexOf(friendlyURLMapper.getMapping())) == -1) continue;
            mappingPart = "/" + layoutURL.substring(mappingIndex);
        }
        Locale currentLocale = themeDisplay.getLocale();
        if (themeDisplay.isI18n()) {
            String i18nPath = themeDisplay.getI18nPath();
            String currentLocalePath = "/" + currentLocale.toLanguageTag();
            if (layoutURL.startsWith(currentLocalePath)) {
                layoutURL = layoutURL.substring(currentLocalePath.length());
            } else if (layoutURL.startsWith(i18nPath)) {
                layoutURL = layoutURL.substring(i18nPath.length());
            }
        }
        int localePrependFriendlyURLStyle = PrefsPropsUtil.getInteger((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), (String)"locale.prepend.friendly.url.style");
        if (!Validator.isBlank((String)themeDisplay.getPathMain()) && layoutURL.startsWith(themeDisplay.getPathMain())) {
            redirect = layoutURL;
        } else if (this.isFriendlyURLResolver(layoutURL) || layout.isTypeControlPanel()) {
            redirect = layoutURL + friendlyURLSeparatorPart;
        } else if (layoutURL.equals("/") || this.isGroupFriendlyURL(layout.getGroup(), layout, layoutURL, currentLocale)) {
            redirect = localePrependFriendlyURLStyle == 0 ? layoutURL : PortalUtil.getGroupFriendlyURL((LayoutSet)layout.getLayoutSet(), (ThemeDisplay)themeDisplay, (Locale)locale);
            if (!redirect.endsWith("/") && !friendlyURLSeparatorPart.startsWith("/")) {
                redirect = redirect + "/";
            }
            if (Validator.isNotNull((String)friendlyURLSeparatorPart)) {
                redirect = redirect + friendlyURLSeparatorPart;
            }
        } else {
            redirect = localePrependFriendlyURLStyle == 0 ? PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale) : PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay, (Locale)locale);
            if (Validator.isNotNull((String)friendlyURLSeparatorPart)) {
                redirect = redirect + friendlyURLSeparatorPart;
            }
            if (Validator.isNotNull((String)mappingPart)) {
                redirect = redirect + mappingPart;
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + queryString;
        }
        return redirect;
    }

    protected boolean isFriendlyURLResolver(String layoutURL) {
        String[] urlSeparators;
        for (String urlSeparator : urlSeparators = FriendlyURLResolverRegistryUtil.getURLSeparators()) {
            if (!layoutURL.contains(urlSeparator)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroupFriendlyURL(Group group, Layout layout, String layoutURL, Locale locale) {
        if (Objects.equals(layoutURL, PortalUtil.getPathContext()) || Objects.equals(layoutURL, PortalUtil.getPathContext() + "/") || PortalUtil.isGroupFriendlyURL((String)layoutURL, (String)group.getFriendlyURL(), (String)layout.getFriendlyURL(locale))) {
            return true;
        }
        int index = layoutURL.indexOf(PortalUtil.getPathContext() + "/");
        String string = layoutURL.substring(index + 1);
        Locale layoutURLLocale = LocaleUtil.fromLanguageId((String)string.substring((index = string.indexOf(47)) + 1), (boolean)true, (boolean)false);
        return layoutURLLocale != null;
    }
}

