/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.layout.admin.kernel.visibility.LayoutVisibilityManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.GroupWrapper;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserPersonalSite;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.model.impl.GroupBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@JSON(strict=true)
public class GroupImpl
extends GroupBaseImpl {
    private static final Group _NULL_STAGING_GROUP = new GroupImpl();
    private static final Log _log = LogFactoryUtil.getLog(GroupImpl.class);
    private static final Snapshot<LayoutVisibilityManager> _layoutVisibilityManagerSnapshot = new Snapshot(GroupImpl.class, LayoutVisibilityManager.class);
    private Group _liveGroup;
    private Group _stagingGroup;
    private UnicodeProperties _typeSettingsUnicodeProperties;

    public void clearStagingGroup() {
        this._stagingGroup = null;
    }

    public List<Group> getAncestors() {
        Group group = this.getLiveGroup();
        if (group == null) {
            group = this;
        }
        ArrayList<Group> groups = null;
        while (!group.isRoot()) {
            group = group.getParentGroup();
            if (groups == null) {
                groups = new ArrayList<Group>();
            }
            groups.add(group);
        }
        if (groups == null) {
            return Collections.emptyList();
        }
        return groups;
    }

    public List<Group> getChildren(boolean site) {
        return GroupLocalServiceUtil.getGroups((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site);
    }

    public List<Group> getChildrenWithLayouts(boolean site, int start, int end, OrderByComparator<Group> orderByComparator) {
        return GroupLocalServiceUtil.getLayoutsGroups((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site, (int)start, (int)end, orderByComparator);
    }

    public int getChildrenWithLayoutsCount(boolean site) {
        return GroupLocalServiceUtil.getLayoutsGroupsCount((long)this.getCompanyId(), (long)this.getGroupId(), (boolean)site);
    }

    public long getDefaultPrivatePlid() {
        return this.getDefaultPlid(true);
    }

    public long getDefaultPublicPlid() {
        return this.getDefaultPlid(false);
    }

    public List<Group> getDescendants(boolean site) {
        return GroupLocalServiceUtil.getGroups((long)this.getCompanyId(), (String)this.getTreePath().concat("_%"), (boolean)site);
    }

    @JSON
    public String getDescriptiveName() throws PortalException {
        return this.getDescriptiveName(LocaleUtil.getMostRelevantLocale());
    }

    public String getDescriptiveName(Locale locale) throws PortalException {
        GroupImpl curGroup = this;
        String name = this.getName(locale);
        if (Validator.isNull((String)name)) {
            name = this.getName(PortalUtil.getSiteDefaultLocale((long)this.getGroupId()));
        }
        if (this.isCompany() && !this.isCompanyStagingGroup()) {
            name = LanguageUtil.get((Locale)locale, (String)"global");
        } else if (this.isControlPanel()) {
            name = LanguageUtil.get((Locale)locale, (String)"control-panel");
        } else if (this.isGuest()) {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            name = company.getName();
        } else if (this.isLayout()) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getClassPK());
            name = layout.getName(locale);
        } else if (this.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)this.getClassPK());
            name = layoutPrototype.getName(locale);
        } else if (this.isLayoutSetPrototype()) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)this.getClassPK());
            name = layoutSetPrototype.getName(locale);
        } else if (this.isOrganization()) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)this.getOrganizationId());
            name = organization.getName();
            curGroup = organization.getGroup();
        } else if (this.isUser()) {
            long userId = this.getClassPK();
            User user = UserLocalServiceUtil.getUser((long)userId);
            name = user.getFullName();
        } else if (this.isUserGroup()) {
            long userGroupId = this.getClassPK();
            UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupId);
            name = userGroup.getName();
        } else if (this.isUserPersonalSite()) {
            name = LanguageUtil.get((Locale)locale, (String)"user-personal-site");
        }
        if (curGroup.isStaged() && !curGroup.isStagedRemotely() && curGroup.isStagingGroup()) {
            Group liveGroup = this.getLiveGroup();
            name = liveGroup.getDescriptiveName(locale);
        }
        return name;
    }

    public Map<Locale, String> getDescriptiveNameMap() throws PortalException {
        HashMap<Locale, String> descriptiveNameMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getCompanyAvailableLocales((long)this.getCompanyId())) {
            descriptiveNameMap.put(locale, this.getDescriptiveName(locale));
        }
        return descriptiveNameMap;
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) {
        return this.getDisplayURL(themeDisplay, false);
    }

    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout) {
        return this.getDisplayURL(themeDisplay, privateLayout, false);
    }

    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout, boolean controlPanel) {
        try {
            if (this.isUser() && LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)privateLayout) > 0 || this._hasPublishedLayout(privateLayout)) {
                String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((LayoutSet)LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)privateLayout), (ThemeDisplay)themeDisplay, (boolean)false, (boolean)controlPanel);
                if (this.isUser()) {
                    return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)groupFriendlyURL, (boolean)false, (boolean)true);
                }
                return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)groupFriendlyURL);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return "";
    }

    public String getIconCssClass() {
        String iconCss = "sites";
        if (this.isCompany()) {
            iconCss = "sites";
        } else if (this.isLayout()) {
            iconCss = "edit-layout";
        } else if (this.isOrganization()) {
            iconCss = "sites";
        } else if (this.isUser()) {
            iconCss = "user";
        } else if (this.isDepot()) {
            iconCss = "books";
        }
        return iconCss;
    }

    public String getIconURL(ThemeDisplay themeDisplay) {
        String iconURL = "";
        iconURL = this.isCompany() ? "../aui/globe" : (this.isLayout() ? "../aui/file" : (this.isOrganization() ? "../aui/globe" : (this.isUser() ? "../aui/user" : "../aui/globe")));
        return iconURL;
    }

    public String getLayoutRootNodeName(boolean privateLayout, Locale locale) {
        String pagesName = "pages";
        if (!this.isLayoutPrototype() && !this.isLayoutSetPrototype()) {
            if (privateLayout) {
                if (this.isUser() || this.isUserGroup()) {
                    pagesName = "my-dashboard";
                } else if (this.isPrivateLayoutsEnabled()) {
                    pagesName = "private-pages";
                }
            } else if (this.isUser() || this.isUserGroup()) {
                pagesName = "my-profile";
            } else if (this.isPrivateLayoutsEnabled()) {
                pagesName = "public-pages";
            }
        }
        return LanguageUtil.get((Locale)locale, (String)pagesName);
    }

    public Group getLiveGroup() {
        if (!this.isStagingGroup()) {
            return null;
        }
        if (this._liveGroup == null) {
            this._liveGroup = GroupLocalServiceUtil.fetchGroup((long)this.getLiveGroupId());
            if (this._liveGroup == null) {
                return null;
            }
            if (this._liveGroup instanceof GroupImpl) {
                GroupImpl groupImpl = (GroupImpl)this._liveGroup;
                groupImpl._stagingGroup = this;
            } else {
                this._liveGroup = new GroupWrapper(this._liveGroup){

                    public Group getStagingGroup() {
                        return GroupImpl.this;
                    }
                };
            }
        }
        return this._liveGroup;
    }

    public String getLiveParentTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getParentLiveGroupTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key);
    }

    public String getLogoURL(ThemeDisplay themeDisplay, boolean useDefault) {
        long logoId = 0L;
        LayoutSet publicLayoutSet = this.getPublicLayoutSet();
        if (publicLayoutSet.getLogoId() > 0L) {
            logoId = publicLayoutSet.getLogoId();
        } else {
            LayoutSet privateLayoutSet = this.getPrivateLayoutSet();
            if (privateLayoutSet.getLogoId() > 0L) {
                logoId = privateLayoutSet.getLogoId();
            }
        }
        if (!(logoId != 0L || useDefault || this.isCompany() && !this.isCompanyStagingGroup() || this.isControlPanel() || this.isGuest())) {
            return null;
        }
        if (logoId > 0L) {
            return StringBundler.concat((Object[])new Object[]{themeDisplay.getPathImage(), "/layout_set_logo?img_id=", logoId, "&t=", WebServerServletTokenUtil.getToken((long)logoId)});
        }
        StringBundler sb = new StringBundler(5);
        sb.append(themeDisplay.getPathImage());
        sb.append("/company_logo?img_id=");
        Company company = themeDisplay.getCompany();
        sb.append(company.getLogoId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)logoId));
        return sb.toString();
    }

    public long getOrganizationId() {
        if (this.isOrganization()) {
            if (this.isStagingGroup()) {
                Group liveGroup = this.getLiveGroup();
                return liveGroup.getClassPK();
            }
            return this.getClassPK();
        }
        return 0L;
    }

    public Group getParentGroup() {
        long parentGroupId = this.getParentGroupId();
        if (parentGroupId <= 0L) {
            return null;
        }
        return GroupLocalServiceUtil.fetchGroup((long)parentGroupId);
    }

    public UnicodeProperties getParentLiveGroupTypeSettingsProperties() {
        block4: {
            try {
                if (this.isLayout()) {
                    Group parentGroup = GroupLocalServiceUtil.getGroup((long)this.getParentGroupId());
                    return parentGroup.getParentLiveGroupTypeSettingsProperties();
                }
                if (this.isStagingGroup()) {
                    Group liveGroup = this.getLiveGroup();
                    return liveGroup.getTypeSettingsProperties();
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        return this.getTypeSettingsProperties();
    }

    public String getPathFriendlyURL(boolean privateLayout, ThemeDisplay themeDisplay) {
        if (privateLayout) {
            if (this.isUser()) {
                return themeDisplay.getPathFriendlyURLPrivateUser();
            }
            return themeDisplay.getPathFriendlyURLPrivateGroup();
        }
        return themeDisplay.getPathFriendlyURLPublic();
    }

    public LayoutSet getPrivateLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return layoutSet;
    }

    public int getPrivateLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return 0;
        }
    }

    public LayoutSet getPublicLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)false);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return layoutSet;
    }

    public int getPublicLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)false);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return 0;
        }
    }

    public long getRemoteLiveGroupId() {
        if (!this.isStagedRemotely()) {
            return 0L;
        }
        return GetterUtil.getLong((String)this.getTypeSettingsProperty("remoteGroupId"));
    }

    public String getScopeDescriptiveName(ThemeDisplay themeDisplay) throws PortalException {
        if (this.getGroupId() == themeDisplay.getScopeGroupId()) {
            if (this.isDepot()) {
                return StringUtil.appendParentheticalSuffix((String)themeDisplay.translate("current-asset-library"), (String)HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale())));
            }
            return StringUtil.appendParentheticalSuffix((String)themeDisplay.translate("current-site"), (String)HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale())));
        }
        if (this.isLayout() && this.getClassPK() == themeDisplay.getPlid()) {
            return StringUtil.appendParentheticalSuffix((String)themeDisplay.translate("current-page"), (String)HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale())));
        }
        if (this.isLayoutPrototype()) {
            return themeDisplay.translate("default");
        }
        return HtmlUtil.escape((String)this.getDescriptiveName(themeDisplay.getLocale()));
    }

    public String getScopeLabel(ThemeDisplay themeDisplay) {
        if (this.isDepot()) {
            if (this.getGroupId() == themeDisplay.getScopeGroupId()) {
                return "current-asset-library";
            }
            return "asset-library";
        }
        if (this.getGroupId() == themeDisplay.getScopeGroupId()) {
            return "current-site";
        }
        if (this.getGroupId() == themeDisplay.getCompanyGroupId()) {
            return "global";
        }
        if (this.isLayout()) {
            return "page";
        }
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.hasAncestor(this.getGroupId())) {
            return "parent-site";
        }
        if (this.hasAncestor(scopeGroup.getGroupId())) {
            return "child-site";
        }
        return "site";
    }

    public String getScopeSimpleName(ThemeDisplay themeDisplay) {
        if (this.isDepot()) {
            return themeDisplay.translate("asset-library-group");
        }
        if (this.getGroupId() == themeDisplay.getCompanyGroupId()) {
            return themeDisplay.translate("global");
        }
        if (this.isLayout()) {
            return themeDisplay.translate("page");
        }
        return themeDisplay.translate("site");
    }

    public Group getStagingGroup() {
        if (this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._stagingGroup == null || this._stagingGroup == _NULL_STAGING_GROUP) {
                this._stagingGroup = GroupLocalServiceUtil.getStagingGroup((long)this.getGroupId());
                if (this._stagingGroup instanceof GroupImpl) {
                    GroupImpl groupImpl = (GroupImpl)this._stagingGroup;
                    groupImpl._liveGroup = this;
                } else {
                    this._stagingGroup = new GroupWrapper(this._stagingGroup){

                        public Group getLiveGroup() {
                            return GroupImpl.this;
                        }
                    };
                }
            }
            return this._stagingGroup;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get staging group for group " + this.getGroupId()), (Throwable)exception);
            }
            return null;
        }
    }

    public String getTypeLabel() {
        return GroupConstants.getTypeLabel((int)this.getType());
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsUnicodeProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsUnicodeProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsUnicodeProperties == null) {
            this._typeSettingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._typeSettingsUnicodeProperties.load(super.getTypeSettings());
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return this._typeSettingsUnicodeProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key);
    }

    public String getUnambiguousName(String name, Locale locale) {
        try {
            return StringUtil.appendParentheticalSuffix((String)name, (String)this.getDescriptiveName(locale));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return name;
        }
    }

    public boolean hasAncestor(long groupId) {
        Group group = this.getLiveGroup();
        if (group == null) {
            group = this;
        }
        String treePath = group.getTreePath();
        return groupId != group.getGroupId() && treePath.contains("/" + groupId + "/");
    }

    public boolean hasLocalOrRemoteStagingGroup() {
        return this.hasRemoteStagingGroup() || this.hasStagingGroup();
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasRemoteStagingGroup() {
        return this.getRemoteStagingGroupCount() > 0;
    }

    public boolean hasStagingGroup() {
        if (this.isStagingGroup() || this._stagingGroup == _NULL_STAGING_GROUP) {
            return false;
        }
        if (this._stagingGroup != null) {
            return true;
        }
        Group stagingGroup = GroupLocalServiceUtil.fetchStagingGroup((long)this.getGroupId());
        if (stagingGroup == null) {
            this._stagingGroup = _NULL_STAGING_GROUP;
            return false;
        }
        this._stagingGroup = stagingGroup;
        return true;
    }

    public boolean isCompany() {
        return this.getClassNameId() == PortalUtil.getClassNameId(Company.class) || this.isCompanyStagingGroup();
    }

    public boolean isCompanyStagingGroup() {
        Group liveGroup = this.getLiveGroup();
        if (liveGroup == null) {
            return false;
        }
        return liveGroup.isCompany();
    }

    public boolean isContentSharingWithChildrenEnabled() {
        int companyContentSharingEnabled = PrefsPropsUtil.getInteger((long)this.getCompanyId(), (String)"sites.content.sharing.with.children.enabled");
        if (companyContentSharingEnabled == 0) {
            return false;
        }
        UnicodeProperties typeSettingsUnicodeProperties = this.getParentLiveGroupTypeSettingsProperties();
        int groupContentSharingEnabled = GetterUtil.getInteger((String)typeSettingsUnicodeProperties.getProperty("contentSharingWithChildrenEnabled"), (int)-1);
        return groupContentSharingEnabled == 3 || companyContentSharingEnabled == 2 && groupContentSharingEnabled == -1;
    }

    public boolean isControlPanel() {
        String groupKey = this.getGroupKey();
        return groupKey.equals("Control Panel");
    }

    public boolean isDepot() {
        return this.getType() == 5;
    }

    public boolean isGuest() {
        String groupKey = this.getGroupKey();
        return groupKey.equals("Guest");
    }

    public boolean isInStagingPortlet(String portletId) {
        Group liveGroup = this.getLiveGroup();
        if (liveGroup == null) {
            return false;
        }
        return liveGroup.isStagedPortlet(portletId);
    }

    public boolean isLayout() {
        return this.getClassNameId() == PortalUtil.getClassNameId(Layout.class);
    }

    public boolean isLayoutPrototype() {
        return this.getClassNameId() == PortalUtil.getClassNameId(LayoutPrototype.class);
    }

    public boolean isLayoutSetPrototype() {
        return this.getClassNameId() == PortalUtil.getClassNameId(LayoutSetPrototype.class);
    }

    public boolean isLimitedToParentSiteMembers() {
        return this.getParentGroupId() != 0L && this.getMembershipRestriction() == 1;
    }

    public boolean isOrganization() {
        return this.getClassNameId() == PortalUtil.getClassNameId(Organization.class);
    }

    public boolean isPrivateLayoutsEnabled() {
        LayoutVisibilityManager layoutVisibilityManager = (LayoutVisibilityManager)_layoutVisibilityManagerSnapshot.get();
        return layoutVisibilityManager.isPrivateLayoutsEnabled(this.getCompanyId());
    }

    public boolean isRegularSite() {
        return this.getClassNameId() == PortalUtil.getClassNameId(Group.class);
    }

    public boolean isRoot() {
        return this.getParentGroupId() == 0L;
    }

    public boolean isShowSite(PermissionChecker permissionChecker, boolean privateSite) throws PortalException {
        if (!(this.isControlPanel() || this.isSite() || this.isUser())) {
            return false;
        }
        boolean showSite = true;
        int siteLayoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)privateSite);
        if (siteLayoutsCount == 0) {
            if (this.isSite()) {
                showSite = privateSite ? PropsValues.MY_SITES_SHOW_PRIVATE_SITES_WITH_NO_LAYOUTS : PropsValues.MY_SITES_SHOW_PUBLIC_SITES_WITH_NO_LAYOUTS;
            } else if (this.isOrganization()) {
                showSite = false;
            } else if (this.isUser()) {
                boolean hasPowerUserRole = RoleLocalServiceUtil.hasUserRole((long)permissionChecker.getUserId(), (long)permissionChecker.getCompanyId(), (String)"Power User", (boolean)true);
                if (privateSite) {
                    showSite = PropsValues.MY_SITES_SHOW_USER_PRIVATE_SITES_WITH_NO_LAYOUTS;
                    if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED && !hasPowerUserRole) {
                        showSite = false;
                    }
                } else {
                    showSite = PropsValues.MY_SITES_SHOW_USER_PUBLIC_SITES_WITH_NO_LAYOUTS;
                    if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED && !hasPowerUserRole) {
                        showSite = false;
                    }
                }
            }
        } else {
            Layout defaultLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateSite, (long)0L);
            if (defaultLayout != null && !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)defaultLayout, (boolean)true, (String)"VIEW")) {
                showSite = false;
            } else if (this.isOrganization() && !this.isSite()) {
                _log.error((Object)("Group " + this.getGroupId() + " is an organization site that does not have pages"));
            }
        }
        return showSite;
    }

    public boolean isStaged() {
        return GetterUtil.getBoolean((String)this.getLiveParentTypeSettingsProperty("staged"));
    }

    public boolean isStagedPortlet(String portletId) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getParentLiveGroupTypeSettingsProperties();
        String typeSettingsProperty = typeSettingsUnicodeProperties.getProperty(StagingUtil.getStagedPortletId((String)(portletId = PortletIdCodec.decodePortletName((String)portletId))));
        if (Validator.isNotNull((String)typeSettingsProperty)) {
            return GetterUtil.getBoolean((String)typeSettingsProperty);
        }
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler == null) {
                return false;
            }
            for (Map.Entry entry : typeSettingsUnicodeProperties.entrySet()) {
                String serviceName;
                PortletDataHandler stagedPortletDataHandler;
                String stagedPortletId;
                Portlet stagedPortlet;
                String key = (String)entry.getKey();
                if (!key.contains("staged-portlet_") || (stagedPortlet = PortletLocalServiceUtil.getPortletById((String)(stagedPortletId = StringUtil.removeSubstring((String)key, (String)"staged-portlet_")))) == null || (stagedPortletDataHandler = stagedPortlet.getPortletDataHandlerInstance()) == null || (serviceName = portletDataHandler.getServiceName()) == null || !serviceName.equals(stagedPortletDataHandler.getServiceName())) continue;
                return GetterUtil.getBoolean((String)((String)entry.getValue()));
            }
            return portletDataHandler.isStaged();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return true;
        }
    }

    public boolean isStagedRemotely() {
        return GetterUtil.getBoolean((String)this.getLiveParentTypeSettingsProperty("stagedRemotely"));
    }

    public boolean isStagingGroup() {
        return this.getLiveGroupId() != 0L;
    }

    public boolean isUser() {
        return this.getClassNameId() == PortalUtil.getClassNameId(User.class);
    }

    public boolean isUserGroup() {
        return this.getClassNameId() == PortalUtil.getClassNameId(UserGroup.class);
    }

    public boolean isUserPersonalSite() {
        return this.getClassNameId() == PortalUtil.getClassNameId(UserPersonalSite.class);
    }

    @Override
    public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
        if (!Objects.equals(LocaleUtil.toLanguageId((Locale)defaultLocale), this.getDefaultLanguageId()) && nameMap != null && Validator.isNull((String)nameMap.get(defaultLocale)) && Validator.isNotNull((String)this.getName(this.getDefaultLanguageId()))) {
            nameMap.put(defaultLocale, this.getName(this.getDefaultLanguageId()));
        }
        super.setNameMap(nameMap, defaultLocale);
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsUnicodeProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsUnicodeProperties) {
        this._typeSettingsUnicodeProperties = typeSettingsUnicodeProperties;
        super.setTypeSettings(this._typeSettingsUnicodeProperties.toString());
    }

    protected long getDefaultPlid(boolean privateLayout) {
        block3: {
            try {
                Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateLayout, (long)0L);
                if (firstLayout != null) {
                    return firstLayout.getPlid();
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)exception);
            }
        }
        return 0L;
    }

    private boolean _hasPublishedLayout(boolean privateLayout) {
        Layout layout = LayoutServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateLayout, (boolean)true);
        return layout != null;
    }
}

