/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.capabilities.WorkflowSupport;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import java.io.File;
import java.io.InputStream;
import java.util.Date;

public class LiferayWorkflowLocalRepositoryWrapper
extends LocalRepositoryWrapper {
    private final WorkflowSupport _workflowSupport;

    public LiferayWorkflowLocalRepositoryWrapper(LocalRepository localRepository, WorkflowSupport workflowSupport) {
        super(localRepository);
        this._workflowSupport = workflowSupport;
    }

    @Override
    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, displayDate, expirationDate, reviewDate, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (ServiceContext)serviceContext);
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (ServiceContext)serviceContext);
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        this._workflowSupport.checkInFileEntry(userId, super.getFileEntry(fileEntryId), dlVersionNumberIncrease, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        this._workflowSupport.checkInFileEntry(userId, super.getFileEntry(fileEntryId), DLVersionNumberIncrease.MINOR, serviceContext);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (ServiceContext)serviceContext);
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        super.revertFileEntry(userId, fileEntryId, version, serviceContext);
        this._workflowSupport.revertFileEntry(userId, super.getFileEntry(fileEntryId), serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, dlVersionNumberIncrease, serviceContext);
        return super.getFileEntry(fileEntryId);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, dlVersionNumberIncrease, serviceContext);
        return super.getFileEntry(fileEntryId);
    }
}

