/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.PhonePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

public abstract class PhoneLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
PhoneLocalService {
    @BeanReference(type=PhoneLocalService.class)
    protected PhoneLocalService phoneLocalService;
    @BeanReference(type=PhonePersistence.class)
    protected PhonePersistence phonePersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PhoneLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Phone addPhone(Phone phone) {
        phone.setNew(true);
        return (Phone)this.phonePersistence.update((BaseModel)phone);
    }

    @Transactional(enabled=false)
    public Phone createPhone(long phoneId) {
        return this.phonePersistence.create(phoneId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Phone deletePhone(long phoneId) throws PortalException {
        return this.phonePersistence.remove(phoneId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Phone deletePhone(Phone phone) {
        return (Phone)this.phonePersistence.remove((BaseModel)phone);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.phonePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Phone.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.phonePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.phonePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.phonePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.phonePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.phonePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Phone fetchPhone(long phoneId) {
        return this.phonePersistence.fetchByPrimaryKey(phoneId);
    }

    public Phone fetchPhoneByUuidAndCompanyId(String uuid, long companyId) {
        return this.phonePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Phone fetchPhoneByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.phonePersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public Phone getPhoneByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.phonePersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public Phone getPhone(long phoneId) throws PortalException {
        return this.phonePersistence.findByPrimaryKey(phoneId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.phoneLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Phone.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("phoneId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.phoneLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Phone.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("phoneId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.phoneLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Phone.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("phoneId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Phone>(){

            public void performAction(Phone phone) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)phone);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Phone.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.phonePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement PhoneLocalServiceImpl#deletePhone(Phone) to avoid orphaned data");
        }
        return this.phoneLocalService.deletePhone((Phone)persistedModel);
    }

    public BasePersistence<Phone> getBasePersistence() {
        return this.phonePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.phonePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Phone getPhoneByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.phonePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Phone> getPhones(int start, int end) {
        return this.phonePersistence.findAll(start, end);
    }

    public int getPhonesCount() {
        return this.phonePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Phone updatePhone(Phone phone) {
        return (Phone)this.phonePersistence.update((BaseModel)phone);
    }

    public PhoneLocalService getPhoneLocalService() {
        return this.phoneLocalService;
    }

    public void setPhoneLocalService(PhoneLocalService phoneLocalService) {
        this.phoneLocalService = phoneLocalService;
    }

    public PhonePersistence getPhonePersistence() {
        return this.phonePersistence;
    }

    public void setPhonePersistence(PhonePersistence phonePersistence) {
        this.phonePersistence = phonePersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        PhoneLocalServiceUtil.setService((PhoneLocalService)this.phoneLocalService);
    }

    public void destroy() {
        PhoneLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return PhoneLocalService.class.getName();
    }

    public CTPersistence<Phone> getCTPersistence() {
        return this.phonePersistence;
    }

    public Class<Phone> getModelClass() {
        return Phone.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Phone>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.phonePersistence);
    }

    protected String getModelClassName() {
        return Phone.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.phonePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

