/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;

public class RepositoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceHttp.class);
    private static final Class<?>[] _addRepositoryParameterTypes0 = new Class[]{String.class, Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, UnicodeProperties.class, ServiceContext.class};
    private static final Class<?>[] _checkRepositoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteRepositoryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getTypeSettingsPropertiesParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateRepositoryParameterTypes6 = new Class[]{Long.TYPE, String.class, String.class};

    public static Repository addRepository(HttpPrincipal httpPrincipal, String externalReferenceCode, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "addRepository", (Class[])_addRepositoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsUnicodeProperties, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Repository)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void checkRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "checkRepository", (Class[])_checkRepositoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "deleteRepository", (Class[])_deleteRepositoryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Repository getRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getRepository", (Class[])_getRepositoryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Repository)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Repository getRepository(HttpPrincipal httpPrincipal, long groupId, String portletId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getRepository", (Class[])_getRepositoryParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, portletId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Repository)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getTypeSettingsProperties", (Class[])_getTypeSettingsPropertiesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (UnicodeProperties)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void updateRepository(HttpPrincipal httpPrincipal, long repositoryId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "updateRepository", (Class[])_updateRepositoryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId, name, description});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

