/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.service.base.RepositoryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLPortletResourcePermissionUtil;

public class RepositoryServiceImpl
extends RepositoryServiceBaseImpl {
    @BeanReference(type=DLFileEntryLocalService.class)
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @BeanReference(type=DLFileVersionLocalService.class)
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=RepositoryClassDefinitionCatalog.class)
    private RepositoryClassDefinitionCatalog _repositoryClassDefinitionCatalog;

    public Repository addRepository(String externalReferenceCode, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = DLPortletResourcePermissionUtil.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_REPOSITORY");
        return this.repositoryLocalService.addRepository(externalReferenceCode, this.getUserId(), groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsUnicodeProperties, false, serviceContext);
    }

    public void checkRepository(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId, 0L, 0L, 0L);
    }

    public void deleteRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"DELETE");
        this.repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public Repository getRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
        return repository;
    }

    public Repository getRepository(long groupId, String portletId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByG_N_P(groupId, portletId, portletId);
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
        return repository;
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getTypeSettingsProperties(repositoryId);
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"UPDATE");
        this.repositoryLocalService.updateRepository(repositoryId, name, description);
    }

    protected void checkModelPermissions(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion;
        if (folderId != 0L) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId);
            if (dlFolder != null) {
                ModelResourcePermission folderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName());
                folderModelResourcePermission.check(this.getPermissionChecker(), folderId, "VIEW");
            }
        } else if (fileEntryId != 0L) {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
            if (dlFileEntry != null) {
                ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
                fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
            }
        } else if (fileVersionId != 0L && (dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(fileVersionId)) != null) {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(this.getPermissionChecker(), dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkRepository(long repositoryId, long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        Group group = this._groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            this.checkModelPermissions(folderId, fileEntryId, fileVersionId);
            return;
        }
        try {
            Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
            if (repository != null) {
                ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
            }
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            throw new InvalidRepositoryIdException(noSuchRepositoryException.getMessage());
        }
    }
}

