/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.WebsiteServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;
import java.util.Objects;

public class WebsiteServiceImpl
extends WebsiteServiceBaseImpl {
    public Website addWebsite(String externalReferenceCode, String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        String actionId = "UPDATE";
        if (Objects.equals(className, "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, actionId);
        return this.websiteLocalService.addWebsite(externalReferenceCode, this.getUserId(), className, classPK, url, typeId, primary, serviceContext);
    }

    public void deleteWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        String actionId = "UPDATE";
        if (Objects.equals(website.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), actionId);
        this.websiteLocalService.deleteWebsite(website);
    }

    public Website fetchWebsiteByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        Website website = this.websiteLocalService.fetchWebsiteByExternalReferenceCode(externalReferenceCode, companyId);
        if (website != null) {
            CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), "VIEW");
        }
        return website;
    }

    public Website getWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), "VIEW");
        return website;
    }

    public List<Website> getWebsites(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.websiteLocalService.getWebsites(user.getCompanyId(), className, classPK);
    }

    public Website updateWebsite(String externalReferenceCode, long websiteId, String url, long typeId, boolean primary) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        String actionId = "UPDATE";
        if (Objects.equals(website.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), actionId);
        return this.websiteLocalService.updateWebsite(externalReferenceCode, websiteId, url, typeId, primary);
    }
}

