/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthVerifierServletRequest
extends ProtectedServletRequest {
    private IsolatedHttpSession _isolatedHttpSession;
    private final Long _userId;

    public AuthVerifierServletRequest(HttpServletRequest httpServletRequest, long userId, String authType) {
        super(httpServletRequest, String.valueOf(userId), authType);
        this._userId = userId;
        httpServletRequest.removeAttribute("USER");
        httpServletRequest.setAttribute("USER_ID", (Object)userId);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        if ("FORM".equals(this.getAuthType())) {
            return httpServletRequest.getSession(create);
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            this._isolatedHttpSession = create ? new IsolatedHttpSession(httpServletRequest.getSession(true)) : null;
        } else if (this._isolatedHttpSession == null || !httpSession.equals(this._isolatedHttpSession._httpSession)) {
            this._isolatedHttpSession = new IsolatedHttpSession(httpSession);
        }
        return this._isolatedHttpSession;
    }

    private class IsolatedHttpSession
    extends HttpSessionWrapper {
        private final Map<String, Object> _attributes;
        private final HttpSession _httpSession;

        public IsolatedHttpSession(HttpSession httpSession) {
            super(httpSession);
            this._attributes = new HashMap<String, Object>();
            this._httpSession = httpSession;
        }

        public Object getAttribute(String name) {
            if (name.equals("USER_ID")) {
                return AuthVerifierServletRequest.this._userId;
            }
            return this._attributes.get(name);
        }

        public void setAttribute(String name, Object value) {
            this._attributes.put(name, value);
        }
    }
}

