/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(TunnelServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !permissionChecker.isSignedIn()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unauthenticated access is forbidden");
            }
            httpServletResponse.setStatus(403);
            return;
        }
        ProtectedClassLoaderObjectInputStream objectInputStream = null;
        Thread thread = Thread.currentThread();
        try {
            objectInputStream = new ProtectedClassLoaderObjectInputStream((InputStream)httpServletRequest.getInputStream(), thread.getContextClassLoader());
        }
        catch (IOException ioException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)ioException);
            }
            return;
        }
        Object returnObject = null;
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        try {
            AccessControlThreadLocal.setRemoteAccess((boolean)true);
            ObjectValuePair ovp = (ObjectValuePair)objectInputStream.readObject();
            MethodHandler methodHandler = (MethodHandler)ovp.getValue();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Method handler " + methodHandler));
            }
            if (methodHandler != null) {
                MethodKey methodKey = methodHandler.getMethodKey();
                if (!this.isValidRequest(methodKey.getDeclaringClass())) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Invalid request " + methodKey.getDeclaringClass()));
                    }
                    return;
                }
                returnObject = methodHandler.invoke();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            _log.error((Throwable)invocationTargetException);
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                returnObject = new SystemException();
            } else if (PropsValues.TUNNEL_SERVLET_HIDE_EXCEPTION_DATA) {
                Class<?> clazz = throwable.getClass();
                returnObject = throwable instanceof PortalException ? new PortalException("Invocation failed due to " + clazz.getName()) : new SystemException("Invocation failed due to " + clazz.getName());
            } else {
                returnObject = throwable instanceof PortalException ? throwable : new SystemException(throwable.getMessage());
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return object " + returnObject));
        }
        if (returnObject != null) {
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());){
                objectOutputStream.writeObject(returnObject);
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
                throw ioException;
            }
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PortalUtil.sendError((int)404, (Exception)new IllegalArgumentException("The GET method is not supported"), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
    }

    protected boolean isValidRequest(Class<?> clazz) {
        String className = clazz.getName();
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

