/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sessionid;

import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionIdServletRequest
extends HttpServletRequestWrapper {
    private static final String _JSESSIONID = "JSESSIONID";
    private static final String _JSESSIONID_ALREADY_SET = "JSESSIONID_ALREADY_SET";
    private static final Log _log = LogFactoryUtil.getLog(SessionIdServletRequest.class);
    private final HttpServletResponse _httpServletResponse;

    public SessionIdServletRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(httpServletRequest);
        this._httpServletResponse = httpServletResponse;
    }

    public HttpSession getSession() {
        HttpSession httpSession = super.getSession();
        this.process(httpSession);
        return httpSession;
    }

    public HttpSession getSession(boolean create) {
        HttpSession httpSession = super.getSession(create);
        this.process(httpSession);
        return httpSession;
    }

    protected void process(HttpSession httpSession) {
        if (httpSession == null || !httpSession.isNew() || !this.isSecure() || this.isRequestedSessionIdFromCookie()) {
            return;
        }
        Object jSessionIdAlreadySet = this.getAttribute(_JSESSIONID_ALREADY_SET);
        if (jSessionIdAlreadySet != null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + httpSession.getId()));
        }
        Cookie cookie = new Cookie(_JSESSIONID, httpSession.getId());
        cookie.setMaxAge(-1);
        CookiesManagerUtil.addCookie((int)2, (Cookie)cookie, (HttpServletRequest)((HttpServletRequest)super.getRequest()), (HttpServletResponse)this._httpServletResponse);
        this.setAttribute(_JSESSIONID_ALREADY_SET, Boolean.TRUE);
    }
}

