/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.setup.SetupWizardSampleDataUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

public class SetupWizardUtil {
    public static final String PROPERTIES_FILE_NAME = "portal-setup-wizard.properties";
    private static final String _NULL_HOLDER = "NULL_HOLDER";
    private static final String _PROPERTIES_PREFIX = "properties--";
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardUtil.class);

    public static String getDefaultLanguageId() {
        Locale defaultLocale = LocaleUtil.getDefault();
        return LocaleUtil.toLanguageId((Locale)defaultLocale);
    }

    public static String getDefaultTimeZoneId() {
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstancePool.getDefaultCompanyId());
            User guestUser = company.getGuestUser();
            return guestUser.getTimeZoneId();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return PropsValues.COMPANY_DEFAULT_TIME_ZONE;
        }
    }

    public static boolean isDefaultDatabase(HttpServletRequest httpServletRequest) {
        boolean hsqldb = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"defaultDatabase", (boolean)PropsValues.JDBC_DEFAULT_URL.contains("hsqldb"));
        boolean jndi = Validator.isNotNull((String)PropsValues.JDBC_DEFAULT_JNDI_NAME);
        return hsqldb && !jndi;
    }

    public static void testDatabase(HttpServletRequest httpServletRequest) throws Exception {
        String driverClassName = SetupWizardUtil._getParameter(httpServletRequest, "jdbc.default.driverClassName", PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME);
        String url = SetupWizardUtil._getParameter(httpServletRequest, "jdbc.default.url", null);
        String userName = SetupWizardUtil._getParameter(httpServletRequest, "jdbc.default.username", null);
        String password = SetupWizardUtil._getParameter(httpServletRequest, "jdbc.default.password", null);
        String jndiName = "";
        if (Validator.isNotNull((String)PropsValues.JDBC_DEFAULT_JNDI_NAME)) {
            jndiName = PropsValues.JDBC_DEFAULT_JNDI_NAME;
        }
        SetupWizardUtil._testConnection(driverClassName, url, userName, password, jndiName);
    }

    public static void updateLanguage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"companyLocale", (String)SetupWizardUtil.getDefaultLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
            return;
        }
        String timeZoneId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"companyTimeZoneId", (String)SetupWizardUtil.getDefaultTimeZoneId());
        CompanyLocalServiceUtil.updateDisplay((long)PortalInstancePool.getDefaultCompanyId(), (String)languageId, (String)timeZoneId);
        SetupWizardUtil._updateLanguage(httpServletRequest, httpServletResponse, languageId, locale);
    }

    public static void updateSetup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties((HttpServletRequest)httpServletRequest, (String)_PROPERTIES_PREFIX);
        unicodeProperties.setProperty("liferay.home", SystemProperties.get((String)"liferay.home"));
        boolean databaseConfigured = SetupWizardUtil._isDatabaseConfigured(unicodeProperties);
        SetupWizardUtil._processDatabaseProperties(httpServletRequest, unicodeProperties, databaseConfigured);
        SetupWizardUtil._processOtherProperties(httpServletRequest, unicodeProperties);
        unicodeProperties.put("setup.wizard.enabled", Boolean.FALSE.toString());
        SetupWizardUtil._updateCompany(httpServletRequest, httpServletResponse, unicodeProperties);
        SetupWizardUtil._updateAdminUser(httpServletRequest, httpServletResponse, unicodeProperties);
        SetupWizardUtil._updateCompanyWebId(httpServletRequest, unicodeProperties);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("SETUP_WIZARD_PROPERTIES", (Object)unicodeProperties);
        httpSession.setAttribute("SETUP_WIZARD_PROPERTIES_FILE_CREATED", (Object)SetupWizardUtil._writePropertiesFile(unicodeProperties));
    }

    private static String _getParameter(HttpServletRequest httpServletRequest, String name, String defaultValue) {
        name = StringBundler.concat((String[])new String[]{_PROPERTIES_PREFIX, name, "--"});
        return ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)name, (String)defaultValue);
    }

    private static String _getUnicodePropertiesStringWithEmptyValue(UnicodeProperties unicodeProperties) {
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            if (!Validator.isNull((String)((String)entry.getValue()))) continue;
            unicodeProperties.setProperty((String)entry.getKey(), _NULL_HOLDER);
        }
        return StringUtil.removeSubstring((String)unicodeProperties.toString(), (String)_NULL_HOLDER);
    }

    private static boolean _isDatabaseConfigured(UnicodeProperties unicodeProperties) {
        String defaultDriverClassName = (String)unicodeProperties.get((Object)"jdbc.default.driverClassName");
        String defaultPassword = (String)unicodeProperties.get((Object)"jdbc.default.password");
        String defaultURL = (String)unicodeProperties.get((Object)"jdbc.default.url");
        String defaultUsername = (String)unicodeProperties.get((Object)"jdbc.default.username");
        return PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME.equals(defaultDriverClassName) && PropsValues.JDBC_DEFAULT_PASSWORD.equals(defaultPassword) && PropsValues.JDBC_DEFAULT_URL.equals(defaultURL) && PropsValues.JDBC_DEFAULT_USERNAME.equals(defaultUsername);
    }

    private static void _processDatabaseProperties(HttpServletRequest httpServletRequest, UnicodeProperties unicodeProperties, boolean databaseConfigured) throws Exception {
        boolean defaultDatabase = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"defaultDatabase", (boolean)true);
        if (defaultDatabase || databaseConfigured) {
            unicodeProperties.remove((Object)"jdbc.default.url");
            unicodeProperties.remove((Object)"jdbc.default.driverClassName");
            unicodeProperties.remove((Object)"jdbc.default.username");
            unicodeProperties.remove((Object)"jdbc.default.password");
        }
    }

    private static void _processOtherProperties(HttpServletRequest httpServletRequest, UnicodeProperties unicodeProperties) throws Exception {
        SetupWizardUtil._processProperty(httpServletRequest, unicodeProperties, "adminFirstName", "default.admin.first.name", PropsValues.DEFAULT_ADMIN_FIRST_NAME);
        SetupWizardUtil._processProperty(httpServletRequest, unicodeProperties, "adminLastName", "default.admin.last.name", PropsValues.DEFAULT_ADMIN_LAST_NAME);
        SetupWizardUtil._processProperty(httpServletRequest, unicodeProperties, "companyName", "company.default.name", PropsValues.COMPANY_DEFAULT_NAME);
    }

    private static void _processProperty(HttpServletRequest httpServletRequest, UnicodeProperties unicodeProperties, String parameterName, String propertyKey, String defaultValue) throws Exception {
        String value = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)parameterName, (String)defaultValue);
        if (!value.equals(defaultValue)) {
            unicodeProperties.put(propertyKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _testConnection(String driverClassName, String url, String userName, String password, String jndiName) throws Exception {
        DataSource dataSource;
        block6: {
            if (!DriverClassNamesHolder.contains(driverClassName)) {
                throw new Exception(StringBundler.concat((String[])new String[]{driverClassName, " is not specified in the portal property \"", "setup.database.driverClassName", "\""}));
            }
            dataSource = null;
            try {
                dataSource = DataSourceFactoryUtil.initDataSource((String)driverClassName, (String)url, (String)userName, (String)password, (String)jndiName);
                Connection connection = dataSource.getConnection();
                Throwable throwable = null;
                if (connection == null) break block6;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block6;
                }
                connection.close();
            }
            catch (Throwable throwable) {
                DataSourceFactoryUtil.destroyDataSource(dataSource);
                throw throwable;
            }
        }
        DataSourceFactoryUtil.destroyDataSource((DataSource)dataSource);
    }

    private static void _updateAdminUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UnicodeProperties unicodeProperties) throws Exception {
        boolean passwordReset;
        String lastName;
        String firstName;
        String emailAddress;
        Company company;
        ThemeDisplay themeDisplay;
        block3: {
            themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            company = CompanyLocalServiceUtil.getCompanyById((long)themeDisplay.getCompanyId());
            emailAddress = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"adminEmailAddress", (String)(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + company.getMx()));
            PropsUtil.set("admin.email.from.address", emailAddress);
            unicodeProperties.put("admin.email.from.address", emailAddress);
            firstName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"adminFirstName", (String)PropsValues.DEFAULT_ADMIN_FIRST_NAME);
            lastName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"adminLastName", (String)PropsValues.DEFAULT_ADMIN_LAST_NAME);
            passwordReset = false;
            try {
                PasswordPolicy passwordPolicy = PasswordPolicyLocalServiceUtil.getDefaultPasswordPolicy((long)company.getCompanyId());
                if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                    passwordReset = true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
        User user = SetupWizardSampleDataUtil.updateAdminUser(company, themeDisplay.getLocale(), themeDisplay.getLanguageId(), emailAddress, firstName, lastName, passwordReset);
        PropsUtil.set("admin.email.from.name", user.getFullName());
        unicodeProperties.put("admin.email.from.name", user.getFullName());
        int index = emailAddress.indexOf(64);
        String companyDefaultWebId = emailAddress.substring(index + 1);
        PropsUtil.set("company.default.web.id", companyDefaultWebId);
        unicodeProperties.put("company.default.web.id", companyDefaultWebId);
        String defaultAdminEmailAddressPrefix = emailAddress.substring(0, index);
        unicodeProperties.put("default.admin.email.address.prefix", defaultAdminEmailAddressPrefix);
        PropsUtil.set("default.admin.email.address.prefix", defaultAdminEmailAddressPrefix);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("EMAIL_ADDRESS", (Object)emailAddress);
        httpSession.setAttribute("SETUP_WIZARD_PASSWORD_UPDATED", (Object)Boolean.TRUE);
        httpSession.setAttribute("USER", (Object)user);
        httpSession.setAttribute("USER_ID", (Object)user.getUserId());
        EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, httpServletRequest, httpServletResponse);
    }

    private static void _updateCompany(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UnicodeProperties unicodeProperties) throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstancePool.getDefaultCompanyId());
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"companyLocale", (String)SetupWizardUtil.getDefaultLanguageId());
        SetupWizardUtil._updateLanguage(httpServletRequest, httpServletResponse, languageId, LocaleUtil.fromLanguageId((String)languageId));
        PropsUtil.set("company.default.locale", languageId);
        unicodeProperties.put("company.default.locale", languageId);
        String timeZoneId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"companyTimeZoneId", (String)SetupWizardUtil.getDefaultTimeZoneId());
        unicodeProperties.put("company.default.time.zone", timeZoneId);
        String companyName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"companyName", (String)PropsValues.COMPANY_DEFAULT_NAME);
        SetupWizardSampleDataUtil.updateCompany(company, companyName, languageId, timeZoneId);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setCompany(company);
    }

    private static void _updateCompanyWebId(HttpServletRequest httpServletRequest, UnicodeProperties unicodeProperties) throws Exception {
        String companyDefaultWebId = (String)unicodeProperties.get((Object)"company.default.web.id");
        if (Validator.isNull((String)companyDefaultWebId)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = CompanyLocalServiceUtil.getCompanyById((long)themeDisplay.getCompanyId());
        if (Objects.equals(companyDefaultWebId, company.getWebId())) {
            return;
        }
        company.setWebId(companyDefaultWebId);
        company.setMx(companyDefaultWebId);
        company = CompanyLocalServiceUtil.updateCompany((Company)company);
        PortalInstances.initCompany(company);
        themeDisplay.setCompany(company);
    }

    private static void _updateLanguage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String languageId, Locale locale) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("LOCALE", (Object)locale);
        httpSession.setAttribute("SETUP_WIZARD_DEFAULT_LOCALE", (Object)languageId);
        LanguageUtil.updateCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLanguageId(languageId);
        themeDisplay.setLocale(locale);
    }

    private static boolean _writePropertiesFile(UnicodeProperties unicodeProperties) {
        try {
            FileUtil.write((String)PropsValues.LIFERAY_HOME, (String)PROPERTIES_FILE_NAME, (String)SetupWizardUtil._getUnicodePropertiesStringWithEmptyValue(unicodeProperties));
            if (FileUtil.exists((String)(PropsValues.LIFERAY_HOME + "/" + PROPERTIES_FILE_NAME))) {
                return true;
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return false;
    }

    private static class DriverClassNamesHolder {
        private static final Set<String> _driverClassNames = new HashSet<String>();

        private DriverClassNamesHolder() {
        }

        public static boolean contains(String driverClassName) {
            return _driverClassNames.contains(driverClassName);
        }

        private static void _add(Object object) {
            _driverClassNames.add(String.valueOf(object));
        }

        static {
            Properties properties = PropsUtil.getProperties("setup.database.driverClassName", true);
            Collection<Object> values = properties.values();
            values.forEach(DriverClassNamesHolder::_add);
        }
    }
}

