/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.bean.LiferayBeanFactory;
import com.liferay.portal.util.PropsValues;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortalApplicationContext
extends XmlWebApplicationContext {
    private static final Log _log = LogFactoryUtil.getLog(PortalApplicationContext.class);

    protected DefaultListableBeanFactory createBeanFactory() {
        return new LiferayBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        block7: {
            try {
                super.loadBeanDefinitions(xmlBeanDefinitionReader);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Throwable)exception);
            }
        }
        xmlBeanDefinitionReader.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver());
        if (PropsValues.SPRING_CONFIGS == null) {
            return;
        }
        for (String configLocation : PropsValues.SPRING_CONFIGS) {
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof FileNotFoundException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)throwable.getMessage());
                    continue;
                }
                _log.error((Throwable)exception);
            }
        }
    }
}

