/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StrutsUtil {
    public static final String TEXT_HTML_DIR = "/html";
    private static final Log _log = LogFactoryUtil.getLog(StrutsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, String servletName, Throwable throwable, String uri) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward URI " + uri));
        }
        if (uri.equals("/common/null.jsp")) {
            return;
        }
        if (!httpServletResponse.isCommitted()) {
            String path = TEXT_HTML_DIR.concat(uri);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward path " + path));
            }
            RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)path);
            if (throwable != null) {
                StrutsUtil._setErrorPageAttributes(httpServletRequest, servletName, throwable);
            }
            try {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) return;
                _log.warn((Throwable)ioException);
                return;
            }
            catch (RuntimeException | ServletException exception) {
                if (throwable == null) {
                    if (exception instanceof ServletException) {
                        ServletException servletException = (ServletException)exception;
                        throwable = servletException.getRootCause();
                    }
                    if (throwable == null) {
                        throwable = exception;
                    }
                    StrutsUtil._setErrorPageAttributes(httpServletRequest, servletName, throwable);
                }
                String errorPath = "/html/common/error.jsp";
                requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)errorPath);
                try {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) return;
                    _log.warn((Throwable)ioException);
                    return;
                }
                catch (ServletException servletException) {
                    throw servletException;
                }
            }
            finally {
                if (throwable != null) {
                    StrutsUtil._removeErrorPageAttributes(httpServletRequest, throwable);
                }
            }
        } else {
            if (!_log.isWarnEnabled()) return;
            _log.warn((Object)(uri + " is already committed"));
        }
    }

    private static void _removeErrorPageAttributes(HttpServletRequest httpServletRequest, Throwable throwable) {
        if (throwable == httpServletRequest.getAttribute("javax.servlet.error.exception")) {
            httpServletRequest.removeAttribute("javax.servlet.error.exception");
            httpServletRequest.removeAttribute("javax.servlet.error.exception_type");
            httpServletRequest.removeAttribute("javax.servlet.error.message");
            httpServletRequest.removeAttribute("javax.servlet.error.request_uri");
            httpServletRequest.removeAttribute("javax.servlet.error.servlet_name");
            httpServletRequest.removeAttribute("javax.servlet.error.status_code");
        }
    }

    private static void _setErrorPageAttributes(HttpServletRequest httpServletRequest, String servletName, Throwable throwable) {
        httpServletRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
        httpServletRequest.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
        httpServletRequest.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
        httpServletRequest.setAttribute("javax.servlet.error.request_uri", (Object)httpServletRequest.getRequestURI());
        httpServletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)servletName);
        httpServletRequest.setAttribute("javax.servlet.error.status_code", (Object)500);
    }
}

