/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletPreferences;

public class UpgradeGroup
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.dropIndexes("Group_", "name");
        this.alterColumnType("Group_", "name", "STRING null");
        try (SafeCloseable safeCloseable = this.addTemporaryIndex("Group_", false, new String[]{"classNameId", "classPK"});){
            this.updateGlobalGroupName();
            this.updateGroupsNames();
        }
    }

    protected void updateGlobalGroupName() throws Exception {
        long[] lArray = PortalInstancePool.getCompanyIds();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long companyId = lArray[i];
            LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
            for (String languageId : PropsValues.LOCALES_ENABLED) {
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                localizedValuesMap.put(locale, LanguageUtil.get((ResourceBundle)LanguageResources.getResourceBundle(locale), (String)"global"));
            }
            String nameXML = LocalizationUtil.getXml((LocalizedValuesMap)localizedValuesMap, (String)"global");
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Group_ set name = ? where companyId = ? and friendlyURL = '/global'");){
                preparedStatement.setString(1, nameXML);
                preparedStatement.setLong(2, companyId);
                preparedStatement.executeUpdate();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGroupsNames() throws Exception {
        Map<Long, String[]> companyLanguageIds = this._getCompanyLanguageIds();
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform(StringBundler.concat((String[])new String[]{"select Group_.companyId as companyId, ", "User_.languageid as companyDefaultLanguageId, ", "groupId, name, typeSettings from Group_ left join ", "User_ on Group_.companyId = User_.companyId where ", "User_.defaultuser = [$TRUE$] and site = [$TRUE$] and ", "friendlyURL != '/global'"})));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Group_ set name = ? where groupId = ?");){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String companyDefaultLanguageId = resultSet.getString("companyDefaultLanguageId");
                long groupId = resultSet.getLong("groupId");
                String name = resultSet.getString("name");
                String typeSettings = resultSet.getString("typeSettings");
                UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(typeSettings).build();
                String defaultLanguageId = companyDefaultLanguageId;
                String[] languageIds = companyLanguageIds.getOrDefault(companyId, PropsValues.LOCALES_ENABLED);
                boolean inheritLocales = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("inheritLocales"), (boolean)true);
                if (!inheritLocales) {
                    defaultLanguageId = typeSettingsUnicodeProperties.getProperty("languageId", defaultLanguageId);
                    String typeSettingsLocales = typeSettingsUnicodeProperties.getProperty("locales");
                    if (Validator.isNotNull((String)typeSettingsLocales)) {
                        languageIds = StringUtil.split((String)typeSettingsLocales);
                    }
                }
                Locale currentDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
                try {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)LocaleUtil.fromLanguageId((String)defaultLanguageId));
                    LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
                    for (String languageId : languageIds) {
                        localizedValuesMap.put(LocaleUtil.fromLanguageId((String)languageId), name);
                    }
                    String nameXML = LocalizationUtil.updateLocalization((Map)localizedValuesMap.getValues(), (String)"", (String)"name", (String)defaultLanguageId);
                    preparedStatement2.setString(1, nameXML);
                    preparedStatement2.setLong(2, groupId);
                    preparedStatement2.addBatch();
                }
                finally {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)currentDefaultLocale);
                }
            }
            preparedStatement2.executeBatch();
        }
    }

    private Map<Long, String[]> _getCompanyLanguageIds() throws Exception {
        HashMap<Long, String[]> companyLanguageIds = new HashMap<Long, String[]>();
        PreparedStatement preparedStatement = this.connection.prepareStatement("select ownerId, preferences from PortalPreferences where ownerType = 1");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            long ownerId = resultSet.getLong("ownerId");
            String preferences = resultSet.getString("preferences");
            PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)1, (String)preferences);
            companyLanguageIds.put(ownerId, PrefsPropsUtil.getStringArray((PortletPreferences)new PortalPreferencesWrapper(portalPreferencesImpl), (String)"locales", (String)",", (String[])PropsValues.LOCALES_ENABLED));
        }
        return companyLanguageIds;
    }
}

