/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

public class UpgradeLayout
extends UpgradeProcess {
    protected void deleteLinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from Layout where layoutPrototypeUuid != '' and ", "layoutPrototypeUuid not in (select uuid_ from ", "LayoutPrototype) and layoutPrototypeLinkEnabled = ", "[$TRUE$]"}));
        }
    }

    protected void deleteOrphanedFriendlyURL() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String sql = "delete from LayoutFriendlyURL where plid not in (select plid from Layout)";
            DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(sql);
            sql = "delete from LayoutFriendlyURL where not exists (select null from Layout where Layout.plid = LayoutFriendlyURL.plid)";
            dbTypeToSQLMap.add(DBType.POSTGRESQL, sql);
            this.runSQL(dbTypeToSQLMap);
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteLinkedOrphanedLayouts();
        this.deleteOrphanedFriendlyURL();
        this.updateLayoutPrototypeLinkEnabled();
        this.updateUnlinkedOrphanedLayouts();
    }

    protected void updateLayoutPrototypeLinkEnabled() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update Layout set layoutPrototypeLinkEnabled = [$FALSE$] where type_ = 'link_to_layout' and layoutPrototypeLinkEnabled = [$TRUE$]");
        }
    }

    protected void updateUnlinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL(StringBundler.concat((String[])new String[]{"update Layout set layoutPrototypeUuid = null where ", "layoutPrototypeUuid != '' and layoutPrototypeUuid not in ", "(select uuid_ from LayoutPrototype) and ", "layoutPrototypeLinkEnabled = [$FALSE$]"}));
        }
    }
}

