/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDLFileEntry
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("DLFileEntry", "externalReferenceCode")) {
            this.alterTableAddColumn("DLFileEntry", "externalReferenceCode", "VARCHAR(75)");
            this._populateExternalReferenceCode();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"DLFileEntry", (String[])new String[]{"expirationDate DATE null", "reviewDate DATE null"})};
    }

    private void _populateExternalReferenceCode() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, fileEntryId from DLFileEntry where externalReferenceCode is null or externalReferenceCode = ''");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update DLFileEntry set externalReferenceCode = ? where ctCollectionId = ? and fileEntryId = ?");){
            while (resultSet.next()) {
                long fileEntryId = resultSet.getLong(2);
                preparedStatement2.setString(1, String.valueOf(fileEntryId));
                preparedStatement2.setLong(2, resultSet.getLong(1));
                preparedStatement2.setLong(3, fileEntryId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

