/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyLayout
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyLayout.class);

    @Override
    protected void doVerify() throws Exception {
        this._verifyLayoutFriendlyURL();
    }

    private String _getReservedLayoutFriendlyURLS() {
        String reservedLayoutFriendlyURLS = "";
        for (int i = 0; i < PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length; ++i) {
            String likeClause = PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i];
            if (PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i].contains("*")) {
                likeClause = StringUtil.replace((String)likeClause, (char)'*', (char)'%');
            }
            if (PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i].contains("_")) {
                likeClause = StringUtil.replace((String)likeClause, (char)'_', (String)"!_");
            }
            reservedLayoutFriendlyURLS = reservedLayoutFriendlyURLS.isEmpty() ? reservedLayoutFriendlyURLS + StringBundler.concat((String[])new String[]{"LIKE '/", likeClause, "' "}) : reservedLayoutFriendlyURLS + StringBundler.concat((String[])new String[]{"OR friendlyURL LIKE '/", likeClause, "' "});
            if (!likeClause.contains("!_")) continue;
            reservedLayoutFriendlyURLS = reservedLayoutFriendlyURLS + "ESCAPE '!'";
        }
        return reservedLayoutFriendlyURLS;
    }

    private void _verifyLayoutFriendlyURL() throws Exception {
        if (PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length == 0) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select plid, friendlyURL from LayoutFriendlyURL where friendlyURL " + this._getReservedLayoutFriendlyURLS());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long plid = resultSet.getLong(1);
                String friendlyURL = resultSet.getString(2);
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Detected reserved friendly URL \"", friendlyURL, "\" Update the friendly URL for the layout with PLID ", plid, "."}));
            }
        }
    }
}

