/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.GroupVerifiableResourcedModel;
import com.liferay.portal.verify.model.LayoutBranchVerifiableResourcedModel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.atomic.AtomicInteger;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);
    private static VerifiableResourcedModel[] _verifiableResourcedModels;

    public static void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        VerifyResourcePermissions verifyResourcePermissions = new VerifyResourcePermissions();
        _verifiableResourcedModels = verifiableResourcedModels;
        verifyResourcePermissions.verify();
    }

    @Override
    protected void doVerify() throws Exception {
        if (ArrayUtil.isNotEmpty((Object[])_verifiableResourcedModels)) {
            this.doVerify(_verifiableResourcedModels);
            return;
        }
        this.doVerify(new GroupVerifiableResourcedModel(), new LayoutBranchVerifiableResourcedModel());
    }

    protected void doVerify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                this._verifyResourcedModel(role, verifiableResourcedModel);
            }
        });
    }

    private String _getVerifyResourcedModelSQL(boolean count, VerifiableResourcedModel verifiableResourcedModel, Role role) {
        StringBundler sb = new StringBundler(28);
        sb.append("select ");
        if (count) {
            sb.append("count(*)");
        } else {
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getUserIdColumnName());
        }
        sb.append(" from ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(" left join ResourcePermission on (ResourcePermission.");
        sb.append("companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.name = '");
        sb.append(verifiableResourcedModel.getModelName());
        sb.append("' and ResourcePermission.scope = ");
        sb.append(4);
        sb.append(" and ResourcePermission.primKeyId = ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".");
        sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
        sb.append(" and ResourcePermission.roleId = ");
        sb.append(role.getRoleId());
        sb.append(") where ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.primKeyId is NULL");
        return SQLTransformer.transform(sb.toString());
    }

    private void _verifyResourcedModel(Role role, VerifiableResourcedModel verifiableResourcedModel) throws Exception {
        int total;
        Throwable throwable;
        LoggingTimer loggingTimer;
        block57: {
            loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());
            throwable = null;
            try (PreparedStatement preparedStatement2 = this.connection.prepareStatement(this._getVerifyResourcedModelSQL(true, verifiableResourcedModel, role));
                 ResultSet resultSet2 = preparedStatement2.executeQuery();){
                if (resultSet2.next()) {
                    total = resultSet2.getInt(1);
                    break block57;
                }
                return;
            }
            catch (Throwable preparedStatement2) {
                throwable = preparedStatement2;
                throw preparedStatement2;
            }
            finally {
                if (loggingTimer != null) {
                    if (throwable != null) {
                        try {
                            loggingTimer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        loggingTimer.close();
                    }
                }
            }
        }
        loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());
        throwable = null;
        try {
            AtomicInteger atomicInteger = new AtomicInteger();
            this.processConcurrently(this._getVerifyResourcedModelSQL(false, verifiableResourcedModel, role), resultSet -> new Object[]{resultSet.getLong(verifiableResourcedModel.getPrimaryKeyColumnName()), resultSet.getLong(verifiableResourcedModel.getUserIdColumnName())}, values -> {
                long primKey = (Long)values[0];
                long ownerId = (Long)values[1];
                long companyId = role.getCompanyId();
                long roleId = role.getRoleId();
                String modelName = verifiableResourcedModel.getModelName();
                int count = atomicInteger.getAndIncrement();
                if (_log.isInfoEnabled() && count % 100000 == 0) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Processed ", count, " of ", total, " resource permissions for company ", companyId, " and model ", modelName}));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"No resource found for {", companyId, ", ", modelName, ", ", 4, ", ", primKey, ", ", roleId, "}"}));
                }
                try {
                    ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)modelName, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to add resource for {", companyId, ", ", modelName, ", ", 4, ", ", primKey, ", ", roleId, "}"}), (Throwable)exception);
                }
            }, null);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (loggingTimer != null) {
                if (throwable != null) {
                    try {
                        loggingTimer.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    loggingTimer.close();
                }
            }
        }
    }
}

