/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.CompanyWebDAVStorageImpl;
import com.liferay.portal.webdav.GroupWebDAVStorageImpl;
import com.liferay.portal.webdav.WebDAVRequestImpl;
import com.liferay.portal.webdav.methods.MethodFactoryUtil;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebDAVServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(WebDAVServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WebDAVStorage storage;
        String userAgent;
        int status;
        block21: {
            block22: {
                block20: {
                    status = 412;
                    userAgent = httpServletRequest.getHeader("User-Agent");
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("User agent " + userAgent));
                    }
                    if (!this.isIgnoredResource(httpServletRequest)) break block20;
                    status = 404;
                    httpServletResponse.setStatus(status);
                    if (!_log.isInfoEnabled()) return;
                    String xLitmus = GetterUtil.getString((String)httpServletRequest.getHeader("X-Litmus"));
                    if (Validator.isNotNull((String)xLitmus)) {
                        xLitmus = xLitmus + " ";
                    }
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status}));
                    return;
                }
                storage = this.getStorage(httpServletRequest);
                if (storage != null) break block21;
                if (!_log.isDebugEnabled()) break block22;
                _log.debug((Object)("Invalid WebDAV path " + httpServletRequest.getPathInfo()));
            }
            httpServletResponse.setStatus(status);
            if (!_log.isInfoEnabled()) return;
            String xLitmus = GetterUtil.getString((String)httpServletRequest.getHeader("X-Litmus"));
            if (Validator.isNotNull((String)xLitmus)) {
                xLitmus = xLitmus + " ";
            }
            _log.info((Object)StringBundler.concat((Object[])new Object[]{xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status}));
            return;
        }
        try {
            if (storage.getRootPath() == null) {
                storage.setRootPath(this.getRootPath(httpServletRequest));
            }
            PermissionChecker permissionChecker = null;
            String remoteUser = httpServletRequest.getRemoteUser();
            if (remoteUser != null) {
                PrincipalThreadLocal.setName((String)remoteUser);
                long userId = GetterUtil.getLong((String)remoteUser);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                HttpSession httpSession = httpServletRequest.getSession();
                httpSession.setAttribute("USER", (Object)user);
            }
            Method method = MethodFactoryUtil.create(httpServletRequest);
            try {
                WebDAVRequestImpl webDAVRequest = new WebDAVRequestImpl(storage, httpServletRequest, httpServletResponse, userAgent, permissionChecker);
                status = method.process((WebDAVRequest)webDAVRequest);
            }
            catch (WebDAVException webDAVException) {
                boolean logError = false;
                for (Throwable throwable = webDAVException; throwable != null; throwable = throwable.getCause()) {
                    if (!(throwable instanceof PrincipalException)) continue;
                    logError = true;
                }
                if (logError) {
                    _log.error((Throwable)webDAVException);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)webDAVException);
                }
                status = 412;
            }
        }
        catch (Exception exception) {
            try {
                _log.error((Throwable)exception);
            }
            catch (Throwable throwable) {
                httpServletResponse.setStatus(status);
                if (!_log.isInfoEnabled()) throw throwable;
                String xLitmus = GetterUtil.getString((String)httpServletRequest.getHeader("X-Litmus"));
                if (Validator.isNotNull((String)xLitmus)) {
                    xLitmus = xLitmus + " ";
                }
                _log.info((Object)StringBundler.concat((Object[])new Object[]{xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status}));
                throw throwable;
            }
            httpServletResponse.setStatus(status);
            if (!_log.isInfoEnabled()) return;
            String xLitmus = GetterUtil.getString((String)httpServletRequest.getHeader("X-Litmus"));
            if (Validator.isNotNull((String)xLitmus)) {
                xLitmus = xLitmus + " ";
            }
            _log.info((Object)StringBundler.concat((Object[])new Object[]{xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status}));
            return;
        }
        httpServletResponse.setStatus(status);
        if (!_log.isInfoEnabled()) return;
        String xLitmus = GetterUtil.getString((String)httpServletRequest.getHeader("X-Litmus"));
        if (Validator.isNotNull((String)xLitmus)) {
            xLitmus = xLitmus + " ";
        }
        _log.info((Object)StringBundler.concat((Object[])new Object[]{xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status}));
        return;
    }

    protected String getRootPath(HttpServletRequest httpServletRequest) {
        String contextPath = HttpComponentsUtil.fixPath((String)PortalUtil.getPathContext((HttpServletRequest)httpServletRequest), (boolean)false, (boolean)true);
        String servletPath = HttpComponentsUtil.fixPath((String)httpServletRequest.getServletPath(), (boolean)false, (boolean)true);
        return contextPath.concat(servletPath);
    }

    protected WebDAVStorage getStorage(HttpServletRequest httpServletRequest) {
        WebDAVStorage storage = null;
        String pathInfo = WebDAVUtil.stripManualCheckInRequiredPath((String)httpServletRequest.getPathInfo());
        String[] pathArray = WebDAVUtil.getPathArray((String)(pathInfo = WebDAVUtil.stripOfficeExtension((String)pathInfo)), (boolean)true);
        if (pathArray.length == 0) {
            storage = (WebDAVStorage)InstancePool.get((String)CompanyWebDAVStorageImpl.class.getName());
        } else if (pathArray.length == 1) {
            storage = (WebDAVStorage)InstancePool.get((String)GroupWebDAVStorageImpl.class.getName());
        } else if (pathArray.length >= 2) {
            storage = WebDAVUtil.getStorage((String)pathArray[1]);
        }
        return storage;
    }

    protected boolean isIgnoredResource(HttpServletRequest httpServletRequest) {
        Object[] pathArray = WebDAVUtil.getPathArray((String)httpServletRequest.getPathInfo(), (boolean)true);
        if (ArrayUtil.isEmpty((Object[])pathArray)) {
            return false;
        }
        for (String ignore : PropsValues.WEBDAV_IGNORE) {
            String[] ignoreArray = ignore.split("/");
            if (ignoreArray.length > pathArray.length) continue;
            boolean match = true;
            for (int i = 1; i <= ignoreArray.length; ++i) {
                if (((String)pathArray[pathArray.length - i]).equals(ignoreArray[ignoreArray.length - i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Skipping over ", httpServletRequest.getMethod(), " ", httpServletRequest.getPathInfo()}));
            }
            return true;
        }
        return false;
    }
}

