/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DLFileVersionImpl
extends DLFileVersionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionImpl.class);
    private transient ExpandoBridge _expandoBridge;
    private UnicodeProperties _extraSettingsUnicodeProperties;

    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        DLFolder dlFolder = this.getFolder();
        return dlFolder.buildTreePath();
    }

    public InputStream getContentStream(boolean incrementCounter) throws PortalException {
        return DLFileEntryLocalServiceUtil.getFileAsStream((long)this.getFileEntryId(), (String)this.getVersion(), (boolean)incrementCounter);
    }

    @Deprecated
    public List<DDMStructure> getDDMStructures() throws PortalException {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)this.getFileEntryTypeId());
        return dlFileEntryType.getDDMStructures();
    }

    public DLFileEntryType getDLFileEntryType() throws PortalException {
        return DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)this.getFileEntryTypeId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        if (this._expandoBridge == null) {
            this._expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)DLFileEntry.class.getName(), (long)this.getPrimaryKey());
        }
        return this._expandoBridge;
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsUnicodeProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsUnicodeProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsUnicodeProperties == null) {
            this._extraSettingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsUnicodeProperties.load(super.getExtraSettings());
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return this._extraSettingsUnicodeProperties;
    }

    public DLFileEntry getFileEntry() throws PortalException {
        return DLFileEntryLocalServiceUtil.getFileEntry((long)this.getFileEntryId());
    }

    public DLFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new DLFolderImpl();
        }
        return DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public String getStoreFileName() {
        if (Validator.isNull((String)this.getStoreUUID())) {
            return this.getVersion();
        }
        return this.getVersion() + "~" + this.getStoreUUID();
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsUnicodeProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsUnicodeProperties) {
        this._extraSettingsUnicodeProperties = extraSettingsUnicodeProperties;
        super.setExtraSettings(this._extraSettingsUnicodeProperties.toString());
    }
}

