/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerUtil;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.DirectoryNameException;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.store.StoreArea;
import com.liferay.document.library.kernel.store.StoreAreaAwareStoreWrapper;
import com.liferay.document.library.kernel.store.StoreAreaProcessor;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class DLStoreImpl
implements DLStore {
    private static final Snapshot<StoreAreaProcessor> _storeAreaProcessorSnapshot = new Snapshot(DLStoreImpl.class, StoreAreaProcessor.class, "(store.type=" + PropsValues.DL_STORE_IMPL + ")");
    private static final Snapshot<Store> _storeSnapshot = new Snapshot(DLStoreImpl.class, Store.class, "(default=true)", true);
    private static Store _wrappedStore = new StoreAreaAwareStoreWrapper(() -> _storeSnapshot.get(), () -> _storeAreaProcessorSnapshot.get());

    public static void setStore(Store store) {
        _wrappedStore = new StoreAreaAwareStoreWrapper(() -> store, () -> _storeAreaProcessorSnapshot.get());
    }

    public void addFile(DLStoreRequest dlStoreRequest, byte[] bytes) throws PortalException {
        try (DLStoreFileProvider dlStoreFileProvider = new DLStoreFileProvider(bytes);){
            this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
            this._addFile(dlStoreRequest, dlStoreFileProvider);
        }
    }

    public void addFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        try (DLStoreFileProvider dlStoreFileProvider = new DLStoreFileProvider(file);){
            this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
            this._addFile(dlStoreRequest, dlStoreFileProvider);
        }
    }

    public void addFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        try (DLStoreFileProvider dlStoreFileProvider = new DLStoreFileProvider(inputStream);){
            this._validate(dlStoreRequest.getFileName(), null, null, dlStoreRequest.isValidateFileExtension(), null);
            this._addFile(dlStoreRequest, dlStoreFileProvider);
        }
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        if (this._isStoreAreaSupported()) {
            StoreAreaProcessor storeAreaProcessor = (StoreAreaProcessor)_storeAreaProcessorSnapshot.get();
            StoreArea.tryRunWithStoreAreas(sourceStoreArea -> storeAreaProcessor.copy(sourceStoreArea.getPath(companyId, repositoryId, new String[]{fileName, fromVersionLabel}), StoreArea.NEW.getPath(companyId, repositoryId, new String[]{fileName, toVersionLabel})), (StoreArea[])new StoreArea[]{StoreArea.LIVE, StoreArea.NEW, StoreArea.DELETED});
        } else {
            _wrappedStore.addFile(companyId, repositoryId, fileName, toVersionLabel, this._getNullSafeInputStream(_wrappedStore.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel)));
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        Message message = new Message();
        message.setValues((Map)HashMapBuilder.put((Object)"companyId", (Object)companyId).put((Object)"dirName", (Object)dirName).put((Object)"repositoryId", (Object)repositoryId).build());
        MessageBusUtil.sendMessage((String)"liferay/document_library_deletion", (Message)message);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this._validate(fileName, null, null, false, "");
        for (String versionLabel : _wrappedStore.getFileVersions(companyId, repositoryId, fileName)) {
            _wrappedStore.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        try {
            _wrappedStore.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        return _wrappedStore.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        return _wrappedStore.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this._validate(fileName, null, null, false, null);
        return _wrappedStore.getFileSize(companyId, repositoryId, fileName, "");
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._validate(fileName, null, null, false, versionLabel);
        return _wrappedStore.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    public void updateFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        try (DLStoreFileProvider dlStoreFileProvider = new DLStoreFileProvider(file);){
            this._validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel());
            this._addFile(dlStoreRequest, dlStoreFileProvider);
        }
    }

    public void updateFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        try (DLStoreFileProvider dlStoreFileProvider = new DLStoreFileProvider(inputStream);){
            this._validate(dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.getSourceFileName(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel());
            this._addFile(dlStoreRequest, dlStoreFileProvider);
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        for (String versionLabel : _wrappedStore.getFileVersions(companyId, repositoryId, fileName)) {
            if (this._isStoreAreaSupported()) {
                StoreAreaProcessor storeAreaProcessor = (StoreAreaProcessor)_storeAreaProcessorSnapshot.get();
                StoreArea.tryRunWithStoreAreas(sourceStoreArea -> storeAreaProcessor.copy(sourceStoreArea.getPath(companyId, repositoryId, new String[]{fileName, versionLabel}), StoreArea.NEW.getPath(companyId, newRepositoryId, new String[]{fileName, versionLabel})), (StoreArea[])new StoreArea[]{StoreArea.LIVE, StoreArea.NEW, StoreArea.DELETED});
            } else {
                _wrappedStore.addFile(companyId, newRepositoryId, fileName, versionLabel, _wrappedStore.getFileAsStream(companyId, repositoryId, fileName, versionLabel));
            }
            _wrappedStore.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        if (this._isStoreAreaSupported()) {
            StoreAreaProcessor storeAreaProcessor = (StoreAreaProcessor)_storeAreaProcessorSnapshot.get();
            StoreArea.tryRunWithStoreAreas(sourceStoreArea -> storeAreaProcessor.copy(sourceStoreArea.getPath(companyId, repositoryId, new String[]{fileName, fromVersionLabel}), StoreArea.NEW.getPath(companyId, repositoryId, new String[]{fileName, toVersionLabel})), (StoreArea[])new StoreArea[]{StoreArea.LIVE, StoreArea.NEW, StoreArea.DELETED});
        } else {
            _wrappedStore.addFile(companyId, repositoryId, fileName, toVersionLabel, this._getNullSafeInputStream(_wrappedStore.getFileAsStream(companyId, repositoryId, fileName, fromVersionLabel)));
        }
        _wrappedStore.deleteFile(companyId, repositoryId, fileName, fromVersionLabel);
    }

    private void _addFile(DLStoreRequest dlStoreRequest, DLStoreFileProvider dlStoreFileProvider) throws PortalException {
        try {
            if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED && AntivirusScannerUtil.isActive()) {
                AntivirusScannerUtil.scan((File)dlStoreFileProvider.getFile());
            }
            try (InputStream inputStream = dlStoreFileProvider.getInputStream();){
                _wrappedStore.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getVersionLabel(), inputStream);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new PrincipalException((Throwable)accessDeniedException);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to scan file " + dlStoreRequest.getFileName(), (Throwable)ioException);
        }
    }

    private InputStream _getNullSafeInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return new UnsyncByteArrayInputStream(new byte[0]);
        }
        return inputStream;
    }

    private boolean _isStoreAreaSupported() {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-174816")) {
            return false;
        }
        return _storeAreaProcessorSnapshot.get() != null;
    }

    private void _validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        if (validateFileExtension) {
            DLValidatorUtil.validateFileExtension((String)fileName);
        }
        DLValidatorUtil.validateSourceFileExtension((String)fileExtension, (String)sourceFileName);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    private static class DLStoreFileProvider
    implements SafeCloseable {
        private final byte[] _bytes;
        private final File _file;
        private final InputStream _inputStream;
        private File _tempFile;

        public DLStoreFileProvider(byte[] bytes) {
            this(bytes, null, null);
        }

        public DLStoreFileProvider(File file) {
            this(null, file, null);
        }

        public DLStoreFileProvider(InputStream inputStream) {
            this(null, null, inputStream);
        }

        public void close() {
            if (this._tempFile != null) {
                this._tempFile.delete();
            }
        }

        public File getFile() throws IOException {
            if (this._file != null) {
                return this._file;
            }
            if (this._tempFile != null) {
                return this._tempFile;
            }
            this._tempFile = this._bytes != null ? FileUtil.createTempFile((byte[])this._bytes) : FileUtil.createTempFile((InputStream)this._inputStream);
            return this._tempFile;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this._file != null) {
                return new FileInputStream(this._file);
            }
            if (this._tempFile != null) {
                return new FileInputStream(this._tempFile);
            }
            if (this._bytes != null) {
                return new UnsyncByteArrayInputStream(this._bytes);
            }
            return this._inputStream;
        }

        private DLStoreFileProvider(byte[] bytes, File file, InputStream inputStream) {
            if (inputStream instanceof ByteArrayFileInputStream) {
                this._bytes = null;
                ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream;
                this._file = byteArrayFileInputStream.getFile();
                this._inputStream = null;
            } else {
                this._bytes = bytes;
                this._file = file;
                this._inputStream = inputStream;
            }
        }
    }
}

