/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.AddressServiceUtil;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrgLaborLocalServiceUtil;
import com.liferay.portal.kernel.service.OrgLaborServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.WebsiteLocalServiceUtil;
import com.liferay.portal.kernel.service.WebsiteServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.kernel.util.comparator.GroupTypeComparator;
import com.liferay.portal.kernel.util.comparator.OrganizationNameComparator;
import com.liferay.portal.kernel.util.comparator.OrganizationTypeComparator;
import com.liferay.portal.kernel.util.comparator.RoleDescriptionComparator;
import com.liferay.portal.kernel.util.comparator.RoleNameComparator;
import com.liferay.portal.kernel.util.comparator.RoleTypeComparator;
import com.liferay.portal.kernel.util.comparator.UserEmailAddressComparator;
import com.liferay.portal.kernel.util.comparator.UserFirstNameComparator;
import com.liferay.portal.kernel.util.comparator.UserGroupDescriptionComparator;
import com.liferay.portal.kernel.util.comparator.UserGroupNameComparator;
import com.liferay.portal.kernel.util.comparator.UserJobTitleComparator;
import com.liferay.portal.kernel.util.comparator.UserLastNameComparator;
import com.liferay.portal.kernel.util.comparator.UserScreenNameComparator;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UsersAdminUtil {
    public static final String CUSTOM_QUESTION = "write-my-own-question";
    public static final Accessor<Organization, String> ORGANIZATION_COUNTRY_NAME_ACCESSOR = new Accessor<Organization, String>(){

        public String get(Organization organization) {
            Address address = organization.getAddress();
            Country country = address.getCountry();
            String countryName = country.getName(LocaleThreadLocal.getThemeDisplayLocale());
            if (Validator.isNull((String)countryName) && (country = CountryServiceUtil.fetchCountry((long)organization.getCountryId())) != null) {
                countryName = country.getName(LocaleThreadLocal.getThemeDisplayLocale());
            }
            return countryName;
        }

        public Class<String> getAttributeClass() {
            return String.class;
        }

        public Class<Organization> getTypeClass() {
            return Organization.class;
        }
    };
    public static final Accessor<Organization, String> ORGANIZATION_REGION_NAME_ACCESSOR = new Accessor<Organization, String>(){

        public String get(Organization organization) {
            Address address = organization.getAddress();
            Region region = address.getRegion();
            String regionName = region.getName();
            if (Validator.isNull((String)regionName) && (region = RegionServiceUtil.fetchRegion((long)organization.getRegionId())) != null) {
                regionName = LanguageUtil.get((Locale)LocaleThreadLocal.getThemeDisplayLocale(), (String)region.getName());
            }
            return regionName;
        }

        public Class<String> getAttributeClass() {
            return String.class;
        }

        public Class<Organization> getTypeClass() {
            return Organization.class;
        }
    };
    public static final Accessor<UserGroupGroupRole, Long> USER_GROUP_GROUP_ROLE_ID_ACCESSOR = new Accessor<UserGroupGroupRole, Long>(){

        public Long get(UserGroupGroupRole userGroupGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole((long)userGroupGroupRole.getRoleId());
            if (role == null) {
                return 0L;
            }
            return role.getRoleId();
        }

        public Class<Long> getAttributeClass() {
            return Long.class;
        }

        public Class<UserGroupGroupRole> getTypeClass() {
            return UserGroupGroupRole.class;
        }
    };
    public static final Accessor<UserGroupGroupRole, String> USER_GROUP_GROUP_ROLE_TITLE_ACCESSOR = new Accessor<UserGroupGroupRole, String>(){

        public String get(UserGroupGroupRole userGroupGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole((long)userGroupGroupRole.getRoleId());
            if (role == null) {
                return "";
            }
            return role.getTitle(LocaleThreadLocal.getThemeDisplayLocale());
        }

        public Class<String> getAttributeClass() {
            return String.class;
        }

        public Class<UserGroupGroupRole> getTypeClass() {
            return UserGroupGroupRole.class;
        }
    };
    public static final Accessor<UserGroupRole, Long> USER_GROUP_ROLE_ID_ACCESSOR = new Accessor<UserGroupRole, Long>(){

        public Long get(UserGroupRole userGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole((long)userGroupRole.getRoleId());
            if (role == null) {
                return 0L;
            }
            return role.getRoleId();
        }

        public Class<Long> getAttributeClass() {
            return Long.class;
        }

        public Class<UserGroupRole> getTypeClass() {
            return UserGroupRole.class;
        }
    };
    public static final Accessor<UserGroupRole, String> USER_GROUP_ROLE_TITLE_ACCESSOR = new Accessor<UserGroupRole, String>(){

        public String get(UserGroupRole userGroupRole) {
            Role role = RoleLocalServiceUtil.fetchRole((long)userGroupRole.getRoleId());
            if (role == null) {
                return "";
            }
            return role.getTitle(LocaleThreadLocal.getThemeDisplayLocale());
        }

        public Class<String> getAttributeClass() {
            return String.class;
        }

        public Class<UserGroupRole> getTypeClass() {
            return UserGroupRole.class;
        }
    };

    public static void addPortletBreadcrumbEntries(Organization organization, HttpServletRequest httpServletRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        PortletURL portletURL = PortletURLBuilder.createRenderURL((MimeResponse)renderResponse).setMVCRenderCommandName("/users_admin/organizations_view_tree").setParameter("screenNavigationCategoryKey", "organizations").setParameter("usersListView", "tree").buildPortletURL();
        List ancestorOrganizations = organization.getAncestors();
        Collections.reverse(ancestorOrganizations);
        for (Organization ancestorOrganization : ancestorOrganizations) {
            portletURL.setParameter("organizationId", String.valueOf(ancestorOrganization.getOrganizationId()));
            if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)ancestorOrganization, (String)"VIEW")) continue;
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)httpServletRequest, (String)ancestorOrganization.getName(), (String)portletURL.toString());
        }
        Organization unescapedOrganization = (Organization)organization.toUnescapedModel();
        portletURL.setParameter("organizationId", String.valueOf(unescapedOrganization.getOrganizationId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)httpServletRequest, (String)unescapedOrganization.getName(), null);
    }

    public static long[] addRequiredRoles(long userId, long[] roleIds) throws PortalException {
        return UsersAdminUtil.addRequiredRoles(UserLocalServiceUtil.getUser((long)userId), roleIds);
    }

    public static long[] addRequiredRoles(User user, long[] roleIds) throws PortalException {
        Role userRole;
        long[] administratorUserIds;
        if (user.isGuestUser()) {
            return UsersAdminUtil.removeRequiredRoles(user, roleIds);
        }
        Role administratorRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"Administrator");
        if (!ArrayUtil.contains((long[])roleIds, (long)administratorRole.getRoleId()) && ArrayUtil.contains((long[])(administratorUserIds = UserLocalServiceUtil.getRoleUserIds((long)administratorRole.getRoleId(), (long)1L)), (long)user.getUserId()) && administratorUserIds.length == 1) {
            roleIds = ArrayUtil.append((long[])roleIds, (long)administratorRole.getRoleId());
        }
        if (!ArrayUtil.contains((long[])roleIds, (long)(userRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User")).getRoleId())) {
            roleIds = ArrayUtil.append((long[])roleIds, (long)userRole.getRoleId());
        }
        return roleIds;
    }

    public static List<Role> filterGroupRoles(PermissionChecker permissionChecker, long groupId, List<Role> roles) throws PortalException {
        List filteredGroupRoles = ListUtil.copy(roles);
        Iterator iterator = filteredGroupRoles.iterator();
        while (iterator.hasNext()) {
            Role groupRole = (Role)iterator.next();
            String roleName = groupRole.getName();
            if (!roleName.equals("Organization User") && !roleName.equals("Site Member")) continue;
            iterator.remove();
        }
        if (permissionChecker.isCompanyAdmin() || permissionChecker.isGroupOwner(groupId)) {
            return filteredGroupRoles;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_USER_ROLES") && !OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getOrganizationId(), (String)"ASSIGN_USER_ROLES")) {
            return Collections.emptyList();
        }
        iterator = filteredGroupRoles.iterator();
        while (iterator.hasNext()) {
            Role groupRole = (Role)iterator.next();
            String roleName = groupRole.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner") && !roleName.equals("Site Administrator") && !roleName.equals("Site Owner") && RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (long)groupRole.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            iterator.remove();
        }
        return filteredGroupRoles;
    }

    public static List<Group> filterGroups(PermissionChecker permissionChecker, List<Group> groups) throws PortalException {
        if (permissionChecker.isCompanyAdmin()) {
            return groups;
        }
        List filteredGroups = ListUtil.copy(groups);
        Iterator iterator = filteredGroups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_MEMBERS")) continue;
            iterator.remove();
        }
        return filteredGroups;
    }

    public static List<Organization> filterOrganizations(PermissionChecker permissionChecker, List<Organization> organizations) throws PortalException {
        if (permissionChecker.isCompanyAdmin()) {
            return organizations;
        }
        List filteredOrganizations = ListUtil.copy(organizations);
        Iterator iterator = filteredOrganizations.iterator();
        while (iterator.hasNext()) {
            Organization organization = (Organization)iterator.next();
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"ASSIGN_MEMBERS")) continue;
            iterator.remove();
        }
        return filteredOrganizations;
    }

    public static List<Role> filterRoles(PermissionChecker permissionChecker, List<Role> roles) {
        Role role;
        List filteredRoles = ListUtil.copy(roles);
        Iterator iterator = filteredRoles.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            String roleName = role.getName();
            if (!roleName.equals("Guest") && !roleName.equals("Organization User") && !roleName.equals("Owner") && !roleName.equals("Site Member") && !roleName.equals("User")) continue;
            iterator.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredRoles;
        }
        iterator = filteredRoles.iterator();
        while (iterator.hasNext()) {
            role = (Role)iterator.next();
            if (RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            iterator.remove();
        }
        return filteredRoles;
    }

    public static long[] filterUnsetGroupUserIds(PermissionChecker permissionChecker, long groupId, long[] userIds) throws PortalException {
        long[] filteredUserIds = userIds;
        for (long userId : userIds) {
            if (!SiteMembershipPolicyUtil.isMembershipProtected(permissionChecker, userId, groupId)) continue;
            filteredUserIds = ArrayUtil.remove((long[])filteredUserIds, (long)userId);
        }
        return filteredUserIds;
    }

    public static long[] filterUnsetOrganizationUserIds(PermissionChecker permissionChecker, long organizationId, long[] userIds) throws PortalException {
        long[] filteredUserIds = userIds;
        for (long userId : userIds) {
            if (!OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)userId, (long)organizationId)) continue;
            filteredUserIds = ArrayUtil.remove((long[])filteredUserIds, (long)userId);
        }
        return filteredUserIds;
    }

    public static List<UserGroupRole> filterUserGroupRoles(PermissionChecker permissionChecker, List<UserGroupRole> userGroupRoles) throws PortalException {
        UserGroupRole userGroupRole;
        List filteredUserGroupRoles = ListUtil.copy(userGroupRoles);
        Iterator iterator = filteredUserGroupRoles.iterator();
        while (iterator.hasNext()) {
            userGroupRole = (UserGroupRole)iterator.next();
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization User") && !roleName.equals("Site Member")) continue;
            iterator.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredUserGroupRoles;
        }
        iterator = filteredUserGroupRoles.iterator();
        while (iterator.hasNext()) {
            userGroupRole = (UserGroupRole)iterator.next();
            if (UserGroupRolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroupRole.getGroupId(), (long)userGroupRole.getRoleId())) continue;
            iterator.remove();
        }
        return filteredUserGroupRoles;
    }

    public static List<UserGroup> filterUserGroups(PermissionChecker permissionChecker, List<UserGroup> userGroups) {
        if (permissionChecker.isCompanyAdmin()) {
            return userGroups;
        }
        List filteredUserGroups = ListUtil.copy(userGroups);
        Iterator iterator = filteredUserGroups.iterator();
        while (iterator.hasNext()) {
            UserGroup userGroup = (UserGroup)iterator.next();
            if (UserGroupPermissionUtil.contains(permissionChecker, userGroup.getUserGroupId(), "ASSIGN_MEMBERS")) continue;
            iterator.remove();
        }
        return filteredUserGroups;
    }

    public static List<Address> getAddresses(ActionRequest actionRequest) {
        return UsersAdminUtil.getAddresses(actionRequest, Collections.emptyList());
    }

    public static List<Address> getAddresses(ActionRequest actionRequest, List<Address> defaultAddresses) {
        String addressesIndexesString = actionRequest.getParameter("addressesIndexes");
        if (addressesIndexesString == null) {
            return defaultAddresses;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        int[] addressesIndexes = StringUtil.split((String)addressesIndexesString, (int)0);
        int addressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"addressPrimary");
        for (int addressesIndex : addressesIndexes) {
            long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressCountryId" + addressesIndex));
            String city = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressCity" + addressesIndex));
            String street1 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet1_" + addressesIndex));
            String street2 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet2_" + addressesIndex));
            String street3 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet3_" + addressesIndex));
            String zip = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressZip" + addressesIndex));
            if (countryId == 0L && Validator.isNull((String)city) && Validator.isNull((String)street1) && Validator.isNull((String)street2) && Validator.isNull((String)street3) && Validator.isNull((String)zip)) continue;
            long addressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressId" + addressesIndex));
            long listTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressListTypeId" + addressesIndex));
            long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressRegionId" + addressesIndex));
            boolean mailing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("addressMailing" + addressesIndex));
            boolean primary = false;
            if (addressesIndex == addressPrimary) {
                primary = true;
            }
            Address address = AddressLocalServiceUtil.createAddress((long)addressId);
            address.setCountryId(countryId);
            address.setListTypeId(listTypeId);
            address.setRegionId(regionId);
            address.setCity(city);
            address.setMailing(mailing);
            address.setPrimary(primary);
            address.setStreet1(street1);
            address.setStreet2(street2);
            address.setStreet3(street3);
            address.setZip(zip);
            addresses.add(address);
        }
        return addresses;
    }

    public static List<EmailAddress> getEmailAddresses(ActionRequest actionRequest) {
        return UsersAdminUtil.getEmailAddresses(actionRequest, Collections.emptyList());
    }

    public static List<EmailAddress> getEmailAddresses(ActionRequest actionRequest, List<EmailAddress> defaultEmailAddresses) {
        String emailAddressesIndexesString = actionRequest.getParameter("emailAddressesIndexes");
        if (emailAddressesIndexesString == null) {
            return defaultEmailAddresses;
        }
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
        int[] emailAddressesIndexes = StringUtil.split((String)emailAddressesIndexesString, (int)0);
        int emailAddressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"emailAddressPrimary");
        for (int emailAddressesIndex : emailAddressesIndexes) {
            String address = ParamUtil.getString((PortletRequest)actionRequest, (String)("emailAddressAddress" + emailAddressesIndex));
            if (Validator.isNull((String)address)) continue;
            long listTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("emailAddressListTypeId" + emailAddressesIndex));
            boolean primary = false;
            if (emailAddressesIndex == emailAddressPrimary) {
                primary = true;
            }
            long emailAddressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("emailAddressId" + emailAddressesIndex));
            EmailAddress emailAddress = EmailAddressLocalServiceUtil.createEmailAddress((long)emailAddressId);
            emailAddress.setAddress(address);
            emailAddress.setListTypeId(listTypeId);
            emailAddress.setPrimary(primary);
            emailAddresses.add(emailAddress);
        }
        return emailAddresses;
    }

    public static long[] getGroupIds(PortletRequest portletRequest) throws PortalException {
        long[] groupIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            groupIds = user.getGroupIds();
        }
        return UsersAdminUtil._getRequestPrimaryKeys(portletRequest, groupIds, "addGroupIds", "deleteGroupIds");
    }

    public static OrderByComparator<Group> getGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new GroupNameComparator(orderByAsc) : (orderByCol.equals("type") ? GroupTypeComparator.getInstance((boolean)orderByAsc) : new GroupNameComparator(orderByAsc));
        return orderByComparator;
    }

    public static Long[] getOrganizationIds(List<Organization> organizations) {
        if (ListUtil.isEmpty(organizations)) {
            return new Long[0];
        }
        Long[] organizationIds = new Long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            organizationIds[i] = organization.getOrganizationId();
        }
        return organizationIds;
    }

    public static long[] getOrganizationIds(PortletRequest portletRequest) throws PortalException {
        long[] organizationIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            organizationIds = user.getOrganizationIds();
        }
        return UsersAdminUtil._getRequestPrimaryKeys(portletRequest, organizationIds, "addOrganizationIds", "deleteOrganizationIds");
    }

    public static OrderByComparator<Organization> getOrganizationOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? OrganizationNameComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("type") ? OrganizationTypeComparator.getInstance((boolean)orderByAsc) : OrganizationNameComparator.getInstance((boolean)orderByAsc));
        return orderByComparator;
    }

    public static List<Organization> getOrganizations(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<Organization> organizations = new ArrayList<Organization>(documents.size());
        for (Document document : documents) {
            long organizationId = GetterUtil.getLong((String)document.get("organizationId"));
            Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
            if (organization == null) {
                organizations = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (organizations == null) continue;
            organizations.add(organization);
        }
        return organizations;
    }

    public static List<OrgLabor> getOrgLabors(ActionRequest actionRequest) {
        int[] orgLaborsIndexes;
        ArrayList<OrgLabor> orgLabors = new ArrayList<OrgLabor>();
        for (int orgLaborsIndex : orgLaborsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"orgLaborsIndexes"), (int)0)) {
            long listTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("orgLaborListTypeId" + orgLaborsIndex), (long)-1L);
            if (listTypeId == -1L) continue;
            long orgLaborId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("orgLaborId" + orgLaborsIndex));
            int sunOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunOpen" + orgLaborsIndex), (int)-1);
            int sunClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunClose" + orgLaborsIndex), (int)-1);
            int monOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monOpen" + orgLaborsIndex), (int)-1);
            int monClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monClose" + orgLaborsIndex), (int)-1);
            int tueOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueOpen" + orgLaborsIndex), (int)-1);
            int tueClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueClose" + orgLaborsIndex), (int)-1);
            int wedOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedOpen" + orgLaborsIndex), (int)-1);
            int wedClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedClose" + orgLaborsIndex), (int)-1);
            int thuOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuOpen" + orgLaborsIndex), (int)-1);
            int thuClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuClose" + orgLaborsIndex), (int)-1);
            int friOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friOpen" + orgLaborsIndex), (int)-1);
            int friClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friClose" + orgLaborsIndex), (int)-1);
            int satOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satOpen" + orgLaborsIndex), (int)-1);
            int satClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satClose" + orgLaborsIndex), (int)-1);
            OrgLabor orgLabor = OrgLaborLocalServiceUtil.createOrgLabor((long)orgLaborId);
            orgLabor.setListTypeId(listTypeId);
            orgLabor.setSunOpen(sunOpen);
            orgLabor.setSunClose(sunClose);
            orgLabor.setMonOpen(monOpen);
            orgLabor.setMonClose(monClose);
            orgLabor.setTueOpen(tueOpen);
            orgLabor.setTueClose(tueClose);
            orgLabor.setWedOpen(wedOpen);
            orgLabor.setWedClose(wedClose);
            orgLabor.setThuOpen(thuOpen);
            orgLabor.setThuClose(thuClose);
            orgLabor.setFriOpen(friOpen);
            orgLabor.setFriClose(friClose);
            orgLabor.setSatOpen(satOpen);
            orgLabor.setSatClose(satClose);
            orgLabors.add(orgLabor);
        }
        return orgLabors;
    }

    public static List<Phone> getPhones(ActionRequest actionRequest) {
        return UsersAdminUtil.getPhones(actionRequest, Collections.emptyList());
    }

    public static List<Phone> getPhones(ActionRequest actionRequest, List<Phone> defaultPhones) {
        String phonesIndexesString = actionRequest.getParameter("phonesIndexes");
        if (phonesIndexesString == null) {
            return defaultPhones;
        }
        ArrayList<Phone> phones = new ArrayList<Phone>();
        int[] phonesIndexes = StringUtil.split((String)phonesIndexesString, (int)0);
        int phonePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"phonePrimary");
        for (int phonesIndex : phonesIndexes) {
            String number = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneNumber" + phonesIndex));
            String extension = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneExtension" + phonesIndex));
            if (Validator.isNull((String)number) && Validator.isNull((String)extension)) continue;
            long typeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("phoneListTypeId" + phonesIndex));
            boolean primary = false;
            if (phonesIndex == phonePrimary) {
                primary = true;
            }
            long phoneId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("phoneId" + phonesIndex));
            Phone phone = PhoneLocalServiceUtil.createPhone((long)phoneId);
            phone.setNumber(number);
            phone.setExtension(extension);
            phone.setListTypeId(typeId);
            phone.setPrimary(primary);
            phones.add(phone);
        }
        return phones;
    }

    public static long[] getRoleIds(PortletRequest portletRequest) throws PortalException {
        long[] roleIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            roleIds = user.getRoleIds();
        }
        return UsersAdminUtil._getRequestPrimaryKeys(portletRequest, roleIds, "addRoleIds", "deleteRoleIds");
    }

    public static OrderByComparator<Role> getRoleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? RoleNameComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("description") ? RoleDescriptionComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("type") ? RoleTypeComparator.getInstance((boolean)orderByAsc) : RoleNameComparator.getInstance((boolean)orderByAsc)));
        return orderByComparator;
    }

    public static <T> String getUserColumnText(Locale locale, List<? extends T> list, Accessor<T, String> accessor, int count) {
        String result = ListUtil.toString(list, accessor, (String)", ");
        if (list.size() < count) {
            String message = LanguageUtil.format((Locale)locale, (String)"and-x-more", (Object)String.valueOf(count - list.size()), (boolean)false);
            result = result + " " + message;
        }
        return result;
    }

    public static long[] getUserGroupIds(PortletRequest portletRequest) throws PortalException {
        long[] userGroupIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            userGroupIds = user.getUserGroupIds();
        }
        return UsersAdminUtil._getRequestPrimaryKeys(portletRequest, userGroupIds, "addUserGroupIds", "deleteUserGroupIds");
    }

    public static OrderByComparator<UserGroup> getUserGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? UserGroupNameComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("description") ? UserGroupDescriptionComparator.getInstance((boolean)orderByAsc) : UserGroupNameComparator.getInstance((boolean)orderByAsc));
        return orderByComparator;
    }

    public static List<UserGroupRole> getUserGroupRoles(PortletRequest portletRequest) throws PortalException {
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user == null) {
            return Collections.emptyList();
        }
        HashSet<UserGroupRole> userGroupRoles = new HashSet<UserGroupRole>(UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)user.getUserId()));
        userGroupRoles.addAll(UsersAdminUtil._getUserGroupRoles(portletRequest, user, "addGroupRolesGroupIds", "addGroupRolesRoleIds"));
        userGroupRoles.removeAll(UsersAdminUtil._getUserGroupRoles(portletRequest, user, "deleteGroupRolesGroupIds", "deleteGroupRolesRoleIds"));
        return new ArrayList<UserGroupRole>(userGroupRoles);
    }

    public static List<UserGroup> getUserGroups(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(documents.size());
        for (Document document : documents) {
            long userGroupId = GetterUtil.getLong((String)document.get("userGroupId"));
            UserGroup userGroup = UserGroupLocalServiceUtil.fetchUserGroup((long)userGroupId);
            if (userGroup == null) {
                userGroups = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(UserGroup.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (userGroups == null) continue;
            userGroups.add(userGroup);
        }
        return userGroups;
    }

    public static OrderByComparator<User> getUserOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("email-address") ? UserEmailAddressComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("first-name") ? UserFirstNameComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("job-title") ? UserJobTitleComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("last-name") ? UserLastNameComparator.getInstance((boolean)orderByAsc) : (orderByCol.equals("screen-name") ? UserScreenNameComparator.getInstance((boolean)orderByAsc) : UserLastNameComparator.getInstance((boolean)orderByAsc)))));
        return orderByComparator;
    }

    public static List<User> getUsers(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<User> users = new ArrayList<User>(documents.size());
        for (Document document : documents) {
            long userId = GetterUtil.getLong((String)document.get("userId"));
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user == null) {
                users = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (users == null) continue;
            users.add(user);
        }
        return users;
    }

    public static List<Website> getWebsites(ActionRequest actionRequest) {
        return UsersAdminUtil.getWebsites(actionRequest, Collections.emptyList());
    }

    public static List<Website> getWebsites(ActionRequest actionRequest, List<Website> defaultWebsites) {
        String websitesIndexesString = actionRequest.getParameter("websitesIndexes");
        if (websitesIndexesString == null) {
            return defaultWebsites;
        }
        ArrayList<Website> websites = new ArrayList<Website>();
        int[] websitesIndexes = StringUtil.split((String)websitesIndexesString, (int)0);
        int websitePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"websitePrimary");
        for (int websitesIndex : websitesIndexes) {
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("websiteUrl" + websitesIndex));
            if (Validator.isNull((String)url)) continue;
            long listTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("websiteListTypeId" + websitesIndex));
            boolean primary = false;
            if (websitesIndex == websitePrimary) {
                primary = true;
            }
            long websiteId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("websiteId" + websitesIndex));
            Website website = WebsiteLocalServiceUtil.createWebsite((long)websiteId);
            website.setUrl(url);
            website.setListTypeId(listTypeId);
            website.setPrimary(primary);
            websites.add(website);
        }
        return websites;
    }

    public static boolean hasUpdateFieldPermission(PermissionChecker permissionChecker, User updatingUser, User updatedUser, String field) throws PortalException {
        String[] fieldEditableDomainNames;
        long updatingUserId;
        if (updatedUser == null) {
            return true;
        }
        if (updatingUser == null && (updatingUserId = PrincipalThreadLocal.getUserId()) > 0L) {
            updatingUser = UserLocalServiceUtil.fetchUserById((long)updatingUserId);
        }
        if (updatingUser != null && !updatingUser.equals(updatedUser) && UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)updatingUser.getUserId(), (String)"UPDATE_USER")) {
            return true;
        }
        for (String userType : PropsUtil.getArray((String)"field.editable.user.types")) {
            if (userType.equals("user-with-mx") && updatedUser.hasCompanyMx()) {
                return true;
            }
            if (!userType.equals("user-without-mx") || updatedUser.hasCompanyMx()) continue;
            return true;
        }
        for (String roleName : PropsUtil.getArray((String)"field.editable.roles")) {
            Role role = RoleLocalServiceUtil.fetchRole((long)updatedUser.getCompanyId(), (String)roleName);
            if (role == null || !RoleLocalServiceUtil.hasUserRole((long)updatedUser.getUserId(), (long)role.getRoleId())) continue;
            return true;
        }
        String emailAddress = updatedUser.getEmailAddress();
        for (String domainName : PropsUtil.getArray((String)"field.editable.domains")) {
            if (!emailAddress.endsWith(domainName)) continue;
            return true;
        }
        for (String domainName : fieldEditableDomainNames = PropsUtil.getArray((String)"field.editable.domains", (Filter)new Filter(field))) {
            if (!domainName.equals("*") && !emailAddress.endsWith(domainName)) continue;
            return true;
        }
        return false;
    }

    public static long[] removeRequiredRoles(long userId, long[] roleIds) throws PortalException {
        return UsersAdminUtil.removeRequiredRoles(UserLocalServiceUtil.getUser((long)userId), roleIds);
    }

    public static long[] removeRequiredRoles(User user, long[] roleIds) throws PortalException {
        Role role = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User");
        return ArrayUtil.remove((long[])roleIds, (long)role.getRoleId());
    }

    public static void updateAddresses(String className, long classPK, List<Address> addresses) throws PortalException {
        HashSet<Long> addressIds = new HashSet<Long>();
        for (Address address : addresses) {
            long addressId = address.getAddressId();
            String name = address.getName();
            String description = address.getDescription();
            String street1 = address.getStreet1();
            String street2 = address.getStreet2();
            String street3 = address.getStreet3();
            String city = address.getCity();
            String zip = address.getZip();
            long regionId = address.getRegionId();
            long countryId = address.getCountryId();
            long listTypeId = address.getListTypeId();
            boolean mailing = address.isMailing();
            boolean primary = address.isPrimary();
            String phoneNumber = address.getPhoneNumber();
            if (addressId <= 0L) {
                address = AddressServiceUtil.addAddress((String)address.getExternalReferenceCode(), (String)className, (long)classPK, (String)name, (String)description, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (long)listTypeId, (boolean)mailing, (boolean)primary, (String)phoneNumber, (ServiceContext)new ServiceContext());
                addressId = address.getAddressId();
            } else {
                AddressServiceUtil.updateAddress((long)addressId, (String)name, (String)description, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (long)listTypeId, (boolean)mailing, (boolean)primary, (String)phoneNumber);
            }
            addressIds.add(addressId);
        }
        addresses = AddressServiceUtil.getAddresses((String)className, (long)classPK);
        for (Address address : addresses) {
            if (addressIds.contains(address.getAddressId())) continue;
            AddressServiceUtil.deleteAddress((long)address.getAddressId());
        }
    }

    public static void updateEmailAddresses(String className, long classPK, List<EmailAddress> emailAddresses) throws PortalException {
        HashSet<Long> emailAddressIds = new HashSet<Long>();
        for (EmailAddress emailAddress : emailAddresses) {
            long emailAddressId = emailAddress.getEmailAddressId();
            String address = emailAddress.getAddress();
            long listTypeId = emailAddress.getListTypeId();
            boolean primary = emailAddress.isPrimary();
            if (emailAddressId <= 0L) {
                emailAddress = EmailAddressServiceUtil.addEmailAddress((String)emailAddress.getExternalReferenceCode(), (String)className, (long)classPK, (String)address, (long)listTypeId, (boolean)primary, (ServiceContext)new ServiceContext());
                emailAddressId = emailAddress.getEmailAddressId();
            } else {
                EmailAddressServiceUtil.updateEmailAddress((String)emailAddress.getExternalReferenceCode(), (long)emailAddressId, (String)address, (long)listTypeId, (boolean)primary);
            }
            emailAddressIds.add(emailAddressId);
        }
        emailAddresses = EmailAddressServiceUtil.getEmailAddresses((String)className, (long)classPK);
        for (EmailAddress emailAddress : emailAddresses) {
            if (emailAddressIds.contains(emailAddress.getEmailAddressId())) continue;
            EmailAddressServiceUtil.deleteEmailAddress((long)emailAddress.getEmailAddressId());
        }
    }

    public static void updateOrgLabors(long classPK, List<OrgLabor> orgLabors) throws PortalException {
        HashSet<Long> orgLaborsIds = new HashSet<Long>();
        for (OrgLabor orgLabor : orgLabors) {
            long orgLaborId = orgLabor.getOrgLaborId();
            long listTypeId = orgLabor.getListTypeId();
            int sunOpen = orgLabor.getSunOpen();
            int sunClose = orgLabor.getSunClose();
            int monOpen = orgLabor.getMonOpen();
            int monClose = orgLabor.getMonClose();
            int tueOpen = orgLabor.getTueOpen();
            int tueClose = orgLabor.getTueClose();
            int wedOpen = orgLabor.getWedOpen();
            int wedClose = orgLabor.getWedClose();
            int thuOpen = orgLabor.getThuOpen();
            int thuClose = orgLabor.getThuClose();
            int friOpen = orgLabor.getFriOpen();
            int friClose = orgLabor.getFriClose();
            int satOpen = orgLabor.getSatOpen();
            int satClose = orgLabor.getSatClose();
            if (orgLaborId <= 0L) {
                orgLabor = OrgLaborServiceUtil.addOrgLabor((long)classPK, (long)listTypeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
                orgLaborId = orgLabor.getOrgLaborId();
            } else {
                OrgLaborServiceUtil.updateOrgLabor((long)orgLaborId, (long)listTypeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
            }
            orgLaborsIds.add(orgLaborId);
        }
        orgLabors = OrgLaborServiceUtil.getOrgLabors((long)classPK);
        for (OrgLabor orgLabor : orgLabors) {
            if (orgLaborsIds.contains(orgLabor.getOrgLaborId())) continue;
            OrgLaborServiceUtil.deleteOrgLabor((long)orgLabor.getOrgLaborId());
        }
    }

    public static void updatePhones(String className, long classPK, List<Phone> phones) throws PortalException {
        HashSet<Long> phoneIds = new HashSet<Long>();
        for (Phone phone : phones) {
            long phoneId = phone.getPhoneId();
            String externalReferenceCode = phone.getExternalReferenceCode();
            String number = phone.getNumber();
            String extension = phone.getExtension();
            long listTypeId = phone.getListTypeId();
            boolean primary = phone.isPrimary();
            if (phoneId <= 0L) {
                phone = PhoneServiceUtil.addPhone((String)externalReferenceCode, (String)className, (long)classPK, (String)number, (String)extension, (long)listTypeId, (boolean)primary, (ServiceContext)new ServiceContext());
                phoneId = phone.getPhoneId();
            } else {
                PhoneServiceUtil.updatePhone((String)externalReferenceCode, (long)phoneId, (String)number, (String)extension, (long)listTypeId, (boolean)primary);
            }
            phoneIds.add(phoneId);
        }
        phones = PhoneServiceUtil.getPhones((String)className, (long)classPK);
        for (Phone phone : phones) {
            if (phoneIds.contains(phone.getPhoneId())) continue;
            PhoneServiceUtil.deletePhone((long)phone.getPhoneId());
        }
    }

    public static void updateWebsites(String className, long classPK, List<Website> websites) throws PortalException {
        HashSet<Long> websiteIds = new HashSet<Long>();
        for (Website website : websites) {
            String externalReferenceCode = website.getExternalReferenceCode();
            long websiteId = website.getWebsiteId();
            String url = website.getUrl();
            long listTypeId = website.getListTypeId();
            boolean primary = website.isPrimary();
            if (websiteId <= 0L) {
                website = WebsiteServiceUtil.addWebsite((String)externalReferenceCode, (String)className, (long)classPK, (String)url, (long)listTypeId, (boolean)primary, (ServiceContext)new ServiceContext());
                websiteId = website.getWebsiteId();
            } else {
                WebsiteServiceUtil.updateWebsite((String)externalReferenceCode, (long)websiteId, (String)url, (long)listTypeId, (boolean)primary);
            }
            websiteIds.add(websiteId);
        }
        websites = WebsiteServiceUtil.getWebsites((String)className, (long)classPK);
        for (Website website : websites) {
            if (websiteIds.contains(website.getWebsiteId())) continue;
            WebsiteServiceUtil.deleteWebsite((long)website.getWebsiteId());
        }
    }

    private static long[] _getRequestPrimaryKeys(PortletRequest portletRequest, long[] currentPKs, String addParam, String deleteParam) {
        Set primaryKeys = SetUtil.fromArray((long[])currentPKs);
        long[] addPrimaryKeys = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)addParam), (long)0L);
        long[] deletePrimaryKeys = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)deleteParam), (long)0L);
        for (long addPrimaryKey : addPrimaryKeys) {
            primaryKeys.add(addPrimaryKey);
        }
        for (long deletePrimaryKey : deletePrimaryKeys) {
            primaryKeys.remove(deletePrimaryKey);
        }
        return ArrayUtil.toLongArray((Collection)primaryKeys);
    }

    private static Set<UserGroupRole> _getUserGroupRoles(PortletRequest portletRequest, User user, String groupIdsParam, String roleIdsParam) {
        long[] groupRolesRoleIds;
        HashSet<UserGroupRole> userGroupRoles = new HashSet<UserGroupRole>();
        long[] groupRolesGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)groupIdsParam), (long)0L);
        if (groupRolesGroupIds.length != (groupRolesRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)roleIdsParam), (long)0L)).length) {
            return userGroupRoles;
        }
        long userId = 0L;
        if (user != null) {
            userId = user.getUserId();
        }
        for (int i = 0; i < groupRolesGroupIds.length; ++i) {
            if (groupRolesGroupIds[i] == 0L || groupRolesRoleIds[i] == 0L) continue;
            UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole((long)0L);
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupRolesGroupIds[i]);
            userGroupRole.setRoleId(groupRolesRoleIds[i]);
            userGroupRoles.add(userGroupRole);
        }
        return userGroupRoles;
    }
}

