/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PrivateFieldPropertyAccessor
implements PropertyAccessStrategy {
    private static final Map<String, PropertyAccess> _propertyAccesses = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private final String _prefix;

    public PrivateFieldPropertyAccessor() {
        this("_");
    }

    public PrivateFieldPropertyAccessor(String prefix) {
        this._prefix = prefix;
    }

    public PropertyAccess buildPropertyAccess(Class clazz, String propertyName) {
        String fieldName = this._prefix.isEmpty() ? propertyName : this._prefix.concat(propertyName);
        return _propertyAccesses.computeIfAbsent(StringBundler.concat((Object[])new Object[]{clazz.hashCode(), "#", clazz.getName(), "#", propertyName}), key -> new FieldPropertyAccess(new FieldHolder(clazz, fieldName)));
    }

    private class FieldPropertyAccess
    implements PropertyAccess {
        private final Getter _getter;
        private final Setter _setter;

        public Getter getGetter() {
            return this._getter;
        }

        public PropertyAccessStrategy getPropertyAccessStrategy() {
            return PrivateFieldPropertyAccessor.this;
        }

        public Setter getSetter() {
            return this._setter;
        }

        private FieldPropertyAccess(FieldHolder fieldHolder) {
            this._getter = new FieldGetter(fieldHolder);
            this._setter = new FieldSetter(fieldHolder);
        }
    }

    private static class FieldSetter
    implements Setter {
        private final FieldHolder _fieldHolder;

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor sessionFactoryImplementor) {
            Field field = this._fieldHolder.getField();
            try {
                field.set(target, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                ReflectionUtil.throwException((Throwable)illegalAccessException);
            }
        }

        private FieldSetter(FieldHolder fieldHolder) {
            this._fieldHolder = fieldHolder;
        }
    }

    private static class FieldHolder {
        private final Class<?> _containerJavaType;
        private Field _field;
        private final String _propertyName;

        public Field getField() {
            if (this._field == null) {
                Class<?> modelClass = this._containerJavaType;
                if (BaseModelImpl.class.isAssignableFrom(modelClass)) {
                    Class<?> superClass = modelClass.getSuperclass();
                    while (BaseModelImpl.class != superClass) {
                        modelClass = superClass;
                        superClass = modelClass.getSuperclass();
                    }
                }
                try {
                    Field field = modelClass.getDeclaredField(this._propertyName);
                    field.setAccessible(true);
                    this._field = field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return (Field)ReflectionUtil.throwException((Throwable)noSuchFieldException);
                }
            }
            return this._field;
        }

        private FieldHolder(Class<?> containerJavaType, String propertyName) {
            this._containerJavaType = containerJavaType;
            this._propertyName = propertyName;
        }
    }

    private static class FieldGetter
    implements Getter {
        private final FieldHolder _fieldHolder;

        public Object get(Object target) {
            Field field = this._fieldHolder.getField();
            try {
                return field.get(target);
            }
            catch (IllegalAccessException illegalAccessException) {
                return ReflectionUtil.throwException((Throwable)illegalAccessException);
            }
        }

        public Object getForInsert(Object target, Map mergeMap, SharedSessionContractImplementor sharedSessionContractImplementor) {
            return this.get(target);
        }

        public Member getMember() {
            return null;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            Field field = this._fieldHolder.getField();
            return field.getType();
        }

        private FieldGetter(FieldHolder fieldHolder) {
            this._fieldHolder = fieldHolder;
        }
    }
}

