/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.defaultpermissions.util;

import com.liferay.portal.kernel.defaultpermissions.configuration.manager.PortalDefaultPermissionsConfigurationManagerUtil;
import com.liferay.portal.kernel.defaultpermissions.resource.PortalDefaultPermissionsModelResource;
import com.liferay.portal.kernel.defaultpermissions.resource.PortalDefaultPermissionsModelResourceRegistry;
import com.liferay.portal.kernel.defaultpermissions.resource.PortalDefaultPermissionsModelResourceRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PortalDefaultPermissionsUtil {
    public static void setModelDefaultPermissions(AuditedModel auditedModel, long companyId, long groupId, ServiceContext serviceContext) throws PortalException {
        Map defaultPermissions = PortalDefaultPermissionsConfigurationManagerUtil.getDefaultPermissions((long)companyId, (long)groupId, (String)auditedModel.getModelClassName());
        if (defaultPermissions == null || defaultPermissions.isEmpty()) {
            return;
        }
        ModelPermissions modelPermissions = serviceContext.getModelPermissions();
        if (modelPermissions == null) {
            modelPermissions = ModelPermissionsFactory.create((String)auditedModel.getModelClassName());
        }
        for (Map.Entry entry : defaultPermissions.entrySet()) {
            modelPermissions.addRolePermissions((String)entry.getKey(), (String[])entry.getValue());
        }
        serviceContext.setModelPermissions(modelPermissions);
        ResourceLocalServiceUtil.updateModelResources((AuditedModel)auditedModel, (ServiceContext)serviceContext);
        PortalDefaultPermissionsModelResourceRegistry portalDefaultPermissionsModelResourceRegistry = PortalDefaultPermissionsModelResourceRegistryUtil.getPortalDefaultPermissionsModelResourceRegistry();
        PortalDefaultPermissionsModelResource portalDefaultPermissionsModelResource = portalDefaultPermissionsModelResourceRegistry.getPortalDefaultPermissionsModelResource(auditedModel.getModelClassName());
        if (portalDefaultPermissionsModelResource.isAllowOverridePermissions()) {
            PortalDefaultPermissionsUtil._removeResource(auditedModel, companyId, ResourceActionsUtil.getModelResourceGuestDefaultActions((String)auditedModel.getModelClassName()), defaultPermissions, "Guest");
            PortalDefaultPermissionsUtil._removeResource(auditedModel, companyId, ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)auditedModel.getModelClassName()), defaultPermissions, "Owner");
            PortalDefaultPermissionsUtil._removeResource(auditedModel, companyId, ResourceActionsUtil.getModelResourceGroupDefaultActions((String)auditedModel.getModelClassName()), defaultPermissions, "Site Member");
        }
    }

    private static void _removeResource(AuditedModel auditedModel, long companyId, List<String> defaultActions, Map<String, String[]> defaultPermissions, String roleName) throws PortalException {
        List<Object> actionIds = Arrays.asList((Object[])defaultPermissions.getOrDefault(roleName, new String[0]));
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
        for (String actionId : defaultActions) {
            if (!ListUtil.isEmpty(actionIds) && actionIds.contains(actionId)) continue;
            ResourceLocalServiceUtil.removeResource((long)auditedModel.getCompanyId(), (String)auditedModel.getModelClassName(), (int)4, (String)String.valueOf(auditedModel.getPrimaryKeyObj()), (long)role.getRoleId(), (String)actionId);
        }
    }
}

