/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class EnumSerializer
extends AbstractSerializer {
    private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
    private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{Enum.class};
    private static final Log _log = LogFactoryUtil.getLog(EnumSerializer.class);

    public boolean canSerialize(Class clazz, Class jsonClass) {
        return clazz.isEnum() && (jsonClass == null || jsonClass == JSONObject.class);
    }

    public Class<?>[] getJSONClasses() {
        return _JSON_CLASSES;
    }

    public Class<?>[] getSerializableClasses() {
        return _SERIALIZABLE_CLASSES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
        JSONObject jsonObject = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                Class<?> clazz = object.getClass();
                jsonObject.put("javaClass", (Object)clazz.getName());
                String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
                if (Validator.isNotNull((String)contextName)) {
                    jsonObject.put("contextName", (Object)contextName);
                }
            }
            catch (Exception exception) {
                throw new MarshallException("Unable to put javaClass", (Throwable)exception);
            }
        }
        try {
            serializerState.push(object, (Object)"", (Object)"enumValue");
            Enum enumObject = (Enum)object;
            jsonObject.put("enumValue", (Object)enumObject.name());
        }
        finally {
            serializerState.pop();
        }
        return jsonObject;
    }

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        this._getJavaClass(jsonObject);
        ObjectMatch objectMatch = ObjectMatch.ROUGHLY_SIMILAR;
        if (jsonObject.has("enumValue")) {
            objectMatch = ObjectMatch.OKAY;
        }
        serializerState.setSerialized(object, (Object)objectMatch);
        return objectMatch;
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        Class<?> javaClass = this._getJavaClass(jsonObject);
        String enumValue = this._getString(jsonObject, "enumValue");
        try {
            Method valueOfMethod = ReflectionUtil.getDeclaredMethod(javaClass, (String)"valueOf", (Class[])new Class[]{String.class});
            Object enumObject = valueOfMethod.invoke(null, enumValue);
            serializerState.setSerialized(object, enumObject);
            return enumObject;
        }
        catch (Exception exception) {
            throw new UnmarshallException(StringBundler.concat((Object[])new Object[]{"Unable to deserialize ", javaClass, " with value ", enumValue}), (Throwable)exception);
        }
    }

    private Class<?> _getJavaClass(JSONObject jsonObject) throws UnmarshallException {
        String javaClassName = this._getString(jsonObject, "javaClass");
        try {
            String contextName = jsonObject.optString("contextName");
            if (Validator.isNull((String)contextName)) {
                return Class.forName(javaClassName);
            }
            ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)contextName);
            if (classLoader != null) {
                return classLoader.loadClass(javaClassName);
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get class loader for class ", javaClassName, " in context ", contextName}));
            }
            return Class.forName(javaClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshallException("Unable to load enum class", (Throwable)classNotFoundException);
        }
    }

    private String _getString(JSONObject jsonObject, String key) throws UnmarshallException {
        String string = jsonObject.optString(key);
        if (Validator.isNull((String)string)) {
            throw new UnmarshallException(key + " is undefined");
        }
        return string;
    }
}

