/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import java.util.Date;

public class LayoutSetPrototypeLayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutModelListener.class);

    public void onAfterCreate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    public void onAfterRemove(Layout layout) {
        this.updateLayoutSetPrototype(layout, new Date());
    }

    public void onAfterUpdate(Layout originalLayout, Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(Layout layout, Date modifiedDate) {
        if (layout == null) {
            return;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)layout.getGroupId());
        if (group == null || !group.isLayoutSetPrototype()) {
            return;
        }
        try {
            LayoutSet layoutSet;
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototype((long)group.getClassPK());
            if (layoutSetPrototype != null && (layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet((long)layoutSetPrototype.getGroupId(), (boolean)true)) != null) {
                layoutSet.setModifiedDate(modifiedDate);
                LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

